/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.log;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.tools4j.elara.flyweight.Flyweight;
import org.tools4j.elara.format.MessagePrinter;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.nobark.loop.LoopCondition;
import org.tools4j.nobark.run.StoppableThread;
import org.tools4j.nobark.run.ThreadLike;

public class MessageLogPrinter
implements AutoCloseable {
    private final PrintWriter printWriter;
    private final boolean close;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public MessageLogPrinter() {
        this(System.out, false);
    }

    public MessageLogPrinter(OutputStream outputStream) {
        this(outputStream, true);
    }

    public MessageLogPrinter(OutputStream outputStream, boolean close) {
        this(new OutputStreamWriter(outputStream), close);
    }

    public MessageLogPrinter(Writer writer) {
        this(writer, true);
    }

    public MessageLogPrinter(Writer writer, boolean close) {
        this.printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.close = close;
    }

    public void flush() {
        this.printWriter.flush();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.close) {
                this.printWriter.close();
            } else {
                this.printWriter.flush();
            }
        }
    }

    public void print(MessageLog.Poller poller, Flyweight<?> flyweight) {
        this.print(poller, flyweight, MessagePrinter.DEFAULT);
    }

    public <M> void print(MessageLog.Poller poller, Flyweight<M> flyweight, MessagePrinter<? super M> printer) {
        this.print(poller, flyweight, msg -> true, printer);
    }

    public <M> void print(MessageLog.Poller poller, Flyweight<M> flyweight, Predicate<? super M> filter, MessagePrinter<? super M> printer) {
        this.print(poller, flyweight, filter, printer, workDone -> workDone);
    }

    public <M> void print(MessageLog.Poller poller, Flyweight<M> flyweight, Predicate<? super M> filter, MessagePrinter<? super M> printer, LoopCondition loopCondition) {
        boolean workDone;
        long[] linePtr = new long[]{0L};
        MessageLog.Handler handler = message -> {
            Object msg = flyweight.init(message, 0);
            long l = linePtr[0];
            linePtr[0] = l + 1L;
            long line = l;
            if (filter.test((Object)msg)) {
                printer.print(line, poller.entryId(), (Object)msg, this.printWriter);
            }
            return MessageLog.Handler.Result.POLL;
        };
        while (loopCondition.loopAgain(workDone = poller.poll(handler) > 0)) {
        }
        this.flush();
    }

    public <M> ThreadLike printInBackground(MessageLog.Poller poller, Flyweight<M> flyweight, Predicate<? super M> filter, MessagePrinter<? super M> printer) {
        Objects.requireNonNull(poller);
        Objects.requireNonNull(flyweight);
        Objects.requireNonNull(filter);
        Objects.requireNonNull(printer);
        return StoppableThread.start(runningCondition -> () -> this.print(poller, flyweight, filter, printer, workDone -> runningCondition.keepRunning()), r -> new Thread(null, r, "log-printer"));
    }
}

