/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.log;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public interface MessageLog
extends AutoCloseable {
    public Appender appender();

    public Poller poller();

    public Poller poller(String var1);

    @Override
    public void close();

    @FunctionalInterface
    public static interface Handler {
        public Result onMessage(DirectBuffer var1);

        public static enum Result {
            PEEK,
            POLL;

        }
    }

    public static interface Poller {
        public long entryId();

        public boolean moveTo(long var1);

        public boolean moveToNext();

        public boolean moveToPrevious();

        public Poller moveToStart();

        public Poller moveToEnd();

        public int poll(Handler var1);
    }

    public static interface AppendingContext
    extends AutoCloseable {
        public MutableDirectBuffer buffer();

        public void commit(int var1);

        public void abort();

        public boolean isClosed();

        @Override
        default public void close() {
            if (!this.isClosed()) {
                this.abort();
            }
        }
    }

    @FunctionalInterface
    public static interface Appender {
        default public void append(DirectBuffer buffer, int offset, int length) {
            try (AppendingContext ctxt = this.appending();){
                ctxt.buffer().putBytes(0, buffer, offset, length);
                ctxt.commit(length);
            }
        }

        public AppendingContext appending();
    }
}

