/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.log;

import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.tools4j.elara.log.MessageLog;

public class InMemoryLog
implements MessageLog {
    public static final int DEFAULT_INITIAL_QUEUE_CAPACITY = 16;
    public static final int DEFAULT_INITIAL_BUFFER_CAPACITY = 256;
    private final int initialBufferCapacity;
    private final boolean removeOnPoll;
    private final boolean initEagerly;
    private int[] lengths;
    private MutableDirectBuffer[] buffers;
    private int start;
    private int size;

    public InMemoryLog() {
        this(16, 256, false, false);
    }

    public InMemoryLog(int initialQueueCapacity, int initialBufferCapacity, boolean removeOnPoll, boolean initEagerly) {
        this.initialBufferCapacity = initialBufferCapacity;
        this.removeOnPoll = removeOnPoll;
        this.initEagerly = initEagerly;
        this.lengths = new int[initialQueueCapacity];
        this.buffers = new MutableDirectBuffer[initialQueueCapacity];
        if (initEagerly) {
            for (int i = 0; i < initialQueueCapacity; ++i) {
                this.buffers[i] = new ExpandableArrayBuffer(initialBufferCapacity);
            }
        }
    }

    @Override
    public MessageLog.Appender appender() {
        this.ensureMessageLogNotClosed();
        return new MessageLog.Appender(){
            final AppendingContext appendContext = new AppendingContext();

            @Override
            public void append(DirectBuffer buffer, int offset, int length) {
                int ix;
                InMemoryLog.this.ensureMessageLogNotClosed();
                if (InMemoryLog.this.size < InMemoryLog.this.buffers.length) {
                    int index = InMemoryLog.this.start + InMemoryLog.this.size;
                    if (index >= InMemoryLog.this.buffers.length) {
                        index -= InMemoryLog.this.buffers.length;
                    }
                    ix = index;
                } else {
                    assert (InMemoryLog.this.size == InMemoryLog.this.buffers.length);
                    int newLen = InMemoryLog.extendedQueueCapacity(InMemoryLog.this.buffers.length);
                    int[] newLengths = new int[newLen];
                    MutableDirectBuffer[] newBuffers = new MutableDirectBuffer[newLen];
                    System.arraycopy(InMemoryLog.this.lengths, InMemoryLog.this.start, newLengths, 0, InMemoryLog.this.size - InMemoryLog.this.start);
                    System.arraycopy(InMemoryLog.this.lengths, 0, newLengths, InMemoryLog.this.size - InMemoryLog.this.start, InMemoryLog.this.start);
                    System.arraycopy(InMemoryLog.this.buffers, InMemoryLog.this.start, newBuffers, 0, InMemoryLog.this.size - InMemoryLog.this.start);
                    System.arraycopy(InMemoryLog.this.buffers, 0, newBuffers, InMemoryLog.this.size - InMemoryLog.this.start, InMemoryLog.this.start);
                    if (InMemoryLog.this.initEagerly) {
                        for (int i = InMemoryLog.this.size; i < newLen; ++i) {
                            newBuffers[i] = new ExpandableArrayBuffer(InMemoryLog.this.initialBufferCapacity);
                        }
                    }
                    InMemoryLog.this.start = 0;
                    InMemoryLog.access$502(InMemoryLog.this, newLengths);
                    InMemoryLog.access$202(InMemoryLog.this, newBuffers);
                    ix = InMemoryLog.this.size;
                }
                InMemoryLog.this.notNull(ix, length).putBytes(0, buffer, offset, length);
                ((InMemoryLog)InMemoryLog.this).lengths[ix] = length;
                InMemoryLog.this.size++;
            }

            @Override
            public AppendingContext appending() {
                InMemoryLog.this.ensureMessageLogNotClosed();
                return this.appendContext.init();
            }

            final class AppendingContext
            implements MessageLog.AppendingContext {
                MutableDirectBuffer buffer;
                int index = -1;

                AppendingContext() {
                }

                void reset() {
                    this.buffer = null;
                    this.index = -1;
                }

                AppendingContext init() {
                    int ix;
                    if (this.buffer != null) {
                        this.abort();
                        throw new IllegalStateException("Aborted unclosed append context");
                    }
                    if (InMemoryLog.this.size < InMemoryLog.this.buffers.length) {
                        int index = InMemoryLog.this.start + InMemoryLog.this.size;
                        if (index >= InMemoryLog.this.buffers.length) {
                            index -= InMemoryLog.this.buffers.length;
                        }
                        ix = index;
                    } else {
                        assert (InMemoryLog.this.size == InMemoryLog.this.buffers.length);
                        int newLen = InMemoryLog.extendedQueueCapacity(InMemoryLog.this.buffers.length);
                        int[] newLengths = new int[newLen];
                        MutableDirectBuffer[] newBuffers = new MutableDirectBuffer[newLen];
                        System.arraycopy(InMemoryLog.this.lengths, InMemoryLog.this.start, newLengths, 0, InMemoryLog.this.size - InMemoryLog.this.start);
                        System.arraycopy(InMemoryLog.this.lengths, 0, newLengths, InMemoryLog.this.size - InMemoryLog.this.start, InMemoryLog.this.start);
                        System.arraycopy(InMemoryLog.this.buffers, InMemoryLog.this.start, newBuffers, 0, InMemoryLog.this.size - InMemoryLog.this.start);
                        System.arraycopy(InMemoryLog.this.buffers, 0, newBuffers, InMemoryLog.this.size - InMemoryLog.this.start, InMemoryLog.this.start);
                        if (InMemoryLog.this.initEagerly) {
                            for (int i = InMemoryLog.this.size; i < newLen; ++i) {
                                newBuffers[i] = new ExpandableArrayBuffer(InMemoryLog.this.initialBufferCapacity);
                            }
                        }
                        InMemoryLog.this.start = 0;
                        InMemoryLog.access$502(InMemoryLog.this, newLengths);
                        InMemoryLog.access$202(InMemoryLog.this, newBuffers);
                        ix = InMemoryLog.this.size;
                    }
                    this.buffer = InMemoryLog.this.notNull(ix, 0);
                    ((InMemoryLog)InMemoryLog.this).lengths[ix] = 0;
                    this.index = ix;
                    return this;
                }

                @Override
                public MutableDirectBuffer buffer() {
                    if (this.buffer != null) {
                        return this.buffer;
                    }
                    throw new IllegalStateException("Append context is closed");
                }

                @Override
                public void commit(int length) {
                    if (this.index < 0) {
                        throw new IllegalStateException("Append context is closed");
                    }
                    InMemoryLog.this.ensureMessageLogNotClosed();
                    ((InMemoryLog)InMemoryLog.this).lengths[this.index] = length;
                    InMemoryLog.this.size++;
                    this.reset();
                }

                @Override
                public void abort() {
                    if (this.index < 0) {
                        throw new IllegalStateException("Append context is closed");
                    }
                    this.reset();
                }

                @Override
                public boolean isClosed() {
                    return this.buffer == null;
                }
            }
        };
    }

    @Override
    public MessageLog.Poller poller() {
        this.ensureMessageLogNotClosed();
        return new MessageLog.Poller(){
            final MutableDirectBuffer message = new UnsafeBuffer(0L, 0);
            int index = 0;

            @Override
            public long entryId() {
                return this.index;
            }

            @Override
            public MessageLog.Poller moveToStart() {
                this.index = 0;
                return this;
            }

            @Override
            public MessageLog.Poller moveToEnd() {
                this.index = InMemoryLog.this.size;
                return this;
            }

            @Override
            public boolean moveToNext() {
                int next = this.index + 1;
                if (next >= InMemoryLog.this.size) {
                    return false;
                }
                this.index = next;
                return true;
            }

            @Override
            public boolean moveToPrevious() {
                int next = this.index - 1;
                if (next < 0) {
                    return false;
                }
                this.index = next;
                return true;
            }

            @Override
            public boolean moveTo(long entryId) {
                if (entryId < 0L) {
                    return false;
                }
                if (entryId < (long)InMemoryLog.this.size) {
                    this.index = (int)entryId;
                    return true;
                }
                return false;
            }

            private void doMoveToNext() {
                if (InMemoryLog.this.removeOnPoll) {
                    InMemoryLog.this.start = InMemoryLog.this.start < InMemoryLog.this.buffers.length ? InMemoryLog.this.start + 1 : 0;
                    InMemoryLog.this.size--;
                } else {
                    ++this.index;
                }
            }

            private int position() {
                int pos = InMemoryLog.this.start + this.index;
                return pos < InMemoryLog.this.buffers.length ? pos : pos - InMemoryLog.this.buffers.length;
            }

            @Override
            public int poll(MessageLog.Handler handler) {
                InMemoryLog.this.ensureMessageLogNotClosed();
                if (this.index < InMemoryLog.this.size) {
                    int pos = this.position();
                    int length = InMemoryLog.this.lengths[pos];
                    MutableDirectBuffer buffer = InMemoryLog.this.buffers[pos];
                    this.message.wrap((DirectBuffer)buffer, 0, length);
                    MessageLog.Handler.Result result = handler.onMessage((DirectBuffer)this.message);
                    this.message.wrap(0L, 0);
                    if (result == MessageLog.Handler.Result.POLL) {
                        this.doMoveToNext();
                        return 1;
                    }
                }
                return 0;
            }
        };
    }

    @Override
    public MessageLog.Poller poller(String id) {
        throw new UnsupportedOperationException("tracking poller not supported");
    }

    public long size() {
        return this.size;
    }

    @Override
    public void close() {
        this.size = 0;
        this.start = 0;
        this.buffers = null;
    }

    private void ensureMessageLogNotClosed() {
        if (this.buffers == null) {
            throw new IllegalStateException("InMemoryLog is closed");
        }
    }

    private MutableDirectBuffer notNull(int index, int minCapacity) {
        MutableDirectBuffer buffer = this.buffers[index];
        if (buffer != null) {
            return buffer;
        }
        this.buffers[index] = new ExpandableArrayBuffer(Math.max(this.initialBufferCapacity, minCapacity));
        return this.buffers[index];
    }

    private static int extendedQueueCapacity(int length) {
        return (int)Math.min((long)length * 2L, Integer.MAX_VALUE);
    }

    static /* synthetic */ int[] access$502(InMemoryLog x0, int[] x1) {
        x0.lengths = x1;
        return x1;
    }

    static /* synthetic */ MutableDirectBuffer[] access$202(InMemoryLog x0, MutableDirectBuffer[] x1) {
        x0.buffers = x1;
        return x1;
    }
}

