/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.log;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.AsciiEncoding;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class ExpandableDirectBuffer
implements MutableDirectBuffer {
    private MutableDirectBuffer buffer;
    private int offset;

    public ExpandableDirectBuffer() {
    }

    public ExpandableDirectBuffer(MutableDirectBuffer buffer) {
        this.buffer = buffer;
        this.offset = 0;
    }

    public ExpandableDirectBuffer(MutableDirectBuffer buffer, int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Negative offset: " + offset);
        }
        this.buffer = buffer;
        this.offset = offset;
    }

    public void wrap(byte[] buffer) {
        throw new UnsupportedOperationException();
    }

    public void wrap(byte[] buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    public void wrap(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public void wrap(ByteBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    public void wrap(DirectBuffer buffer) {
        if (this.buffer != buffer) {
            if (buffer != null && !(buffer instanceof MutableDirectBuffer)) {
                throw new IllegalArgumentException("Buffer must be a mutable buffer: " + buffer);
            }
            this.buffer = (MutableDirectBuffer)buffer;
        }
        this.offset = 0;
    }

    public void wrap(MutableDirectBuffer buffer, int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Negative offset: " + offset);
        }
        if (this.buffer != buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        if (buffer != null && !(buffer instanceof MutableDirectBuffer)) {
            throw new IllegalArgumentException("Buffer must be a mutable buffer: " + buffer);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Negative length: " + length);
        }
        this.wrap((MutableDirectBuffer)buffer, length);
    }

    public void wrap(long address, int length) {
        throw new UnsupportedOperationException();
    }

    public void unwrap() {
        this.buffer = null;
        this.offset = 0;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public long addressOffset() {
        return this.buffer == null ? null : Long.valueOf(this.buffer.addressOffset() + (long)this.offset);
    }

    public byte[] byteArray() {
        return this.buffer == null ? null : this.buffer.byteArray();
    }

    public ByteBuffer byteBuffer() {
        return this.buffer == null ? null : this.buffer.byteBuffer();
    }

    public void setMemory(int index, int length, byte value) {
        this.ensureCapacity(index, length);
        this.buffer.setMemory(index + this.offset, length, value);
    }

    public int capacity() {
        return this.buffer.capacity() - this.offset;
    }

    public boolean isExpandable() {
        return this.buffer.isExpandable();
    }

    public void checkLimit(int limit) {
        if (limit < 0) {
            throw new IndexOutOfBoundsException("limit cannot be negative: limit=" + limit);
        }
        this.ensureCapacity(limit + this.offset, 1);
    }

    public long getLong(int index, ByteOrder byteOrder) {
        return this.buffer.getLong(index + this.offset, byteOrder);
    }

    public void putLong(int index, long value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 8);
        this.buffer.putLong(index + this.offset, value, byteOrder);
    }

    public long getLong(int index) {
        return this.buffer.getLong(index + this.offset);
    }

    public void putLong(int index, long value) {
        this.ensureCapacity(index, 8);
        this.buffer.putLong(index + this.offset, value);
    }

    public int getInt(int index, ByteOrder byteOrder) {
        return this.buffer.getInt(index + this.offset, byteOrder);
    }

    public void putInt(int index, int value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 4);
        this.buffer.putInt(index + this.offset, value, byteOrder);
    }

    public int getInt(int index) {
        return this.buffer.getInt(index + this.offset);
    }

    public void putInt(int index, int value) {
        this.ensureCapacity(index, 4);
        this.buffer.putInt(index + this.offset, value);
    }

    public double getDouble(int index, ByteOrder byteOrder) {
        return this.buffer.getDouble(index + this.offset, byteOrder);
    }

    public void putDouble(int index, double value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 8);
        this.buffer.putDouble(index + this.offset, value, byteOrder);
    }

    public double getDouble(int index) {
        return this.buffer.getDouble(index + this.offset);
    }

    public void putDouble(int index, double value) {
        this.ensureCapacity(index, 8);
        this.buffer.putDouble(index + this.offset, value);
    }

    public float getFloat(int index, ByteOrder byteOrder) {
        return this.buffer.getFloat(index + this.offset, byteOrder);
    }

    public void putFloat(int index, float value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 4);
        this.buffer.putFloat(index + this.offset, value, byteOrder);
    }

    public float getFloat(int index) {
        return this.buffer.getFloat(index + this.offset);
    }

    public void putFloat(int index, float value) {
        this.ensureCapacity(index, 4);
        this.buffer.putFloat(index + this.offset, value);
    }

    public short getShort(int index, ByteOrder byteOrder) {
        return this.buffer.getShort(index + this.offset, byteOrder);
    }

    public void putShort(int index, short value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 2);
        this.buffer.putShort(index + this.offset, value, byteOrder);
    }

    public short getShort(int index) {
        return this.buffer.getShort(index + this.offset);
    }

    public void putShort(int index, short value) {
        this.ensureCapacity(index, 2);
        this.buffer.putShort(index + this.offset, value);
    }

    public byte getByte(int index) {
        return this.buffer.getByte(index + this.offset);
    }

    public void putByte(int index, byte value) {
        this.ensureCapacity(index, 1);
        this.buffer.putByte(index + this.offset, value);
    }

    public void getBytes(int index, byte[] dst) {
        this.buffer.getBytes(index + this.offset, dst);
    }

    public void getBytes(int index, byte[] dst, int offset, int length) {
        this.buffer.getBytes(index + offset, dst, offset, length);
    }

    public void getBytes(int index, MutableDirectBuffer dstBuffer, int dstIndex, int length) {
        this.buffer.getBytes(index + this.offset, dstBuffer, dstIndex, length);
    }

    public void getBytes(int index, ByteBuffer dstBuffer, int length) {
        this.buffer.getBytes(index + this.offset, dstBuffer, length);
    }

    public void getBytes(int index, ByteBuffer dstBuffer, int dstOffset, int length) {
        this.buffer.getBytes(index + this.offset, dstBuffer, dstOffset, length);
    }

    public void putBytes(int index, byte[] src) {
        this.putBytes(index, src, 0, src.length);
    }

    public void putBytes(int index, byte[] src, int offset, int length) {
        this.ensureCapacity(index, length);
        this.buffer.putBytes(index + offset, src, offset, length);
    }

    public void putBytes(int index, ByteBuffer srcBuffer, int length) {
        int srcIndex = srcBuffer.position();
        this.putBytes(index, srcBuffer, srcIndex, length);
        srcBuffer.position(srcIndex + length);
    }

    public void putBytes(int index, ByteBuffer srcBuffer, int srcIndex, int length) {
        this.ensureCapacity(index, length);
        this.buffer.putBytes(index + this.offset, srcBuffer, srcIndex, length);
    }

    public void putBytes(int index, DirectBuffer srcBuffer, int srcIndex, int length) {
        this.ensureCapacity(index, length);
        this.buffer.putBytes(index + this.offset, srcBuffer, srcIndex, length);
    }

    public char getChar(int index, ByteOrder byteOrder) {
        return this.buffer.getChar(index + this.offset, byteOrder);
    }

    public void putChar(int index, char value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 2);
        this.buffer.putChar(index + this.offset, value, byteOrder);
    }

    public char getChar(int index) {
        return this.buffer.getChar(index + this.offset);
    }

    public void putChar(int index, char value) {
        this.ensureCapacity(index, 2);
        this.buffer.putChar(index + this.offset, value);
    }

    public String getStringAscii(int index) {
        return this.buffer.getStringAscii(index + this.offset);
    }

    public int getStringAscii(int index, Appendable appendable) {
        return this.buffer.getStringAscii(index + this.offset, appendable);
    }

    public String getStringAscii(int index, ByteOrder byteOrder) {
        return this.buffer.getStringAscii(index + this.offset, byteOrder);
    }

    public int getStringAscii(int index, Appendable appendable, ByteOrder byteOrder) {
        return this.buffer.getStringAscii(index + this.offset, appendable, byteOrder);
    }

    public String getStringAscii(int index, int length) {
        return this.buffer.getStringAscii(index + this.offset, length);
    }

    public int getStringAscii(int index, int length, Appendable appendable) {
        return this.buffer.getStringAscii(index + this.offset, length, appendable);
    }

    public int putStringAscii(int index, String value) {
        int length = value != null ? value.length() : 0;
        this.ensureCapacity(index, length + 4);
        return this.buffer.putStringAscii(index + this.offset, value);
    }

    public int putStringAscii(int index, String value, ByteOrder byteOrder) {
        int length = value != null ? value.length() : 0;
        this.ensureCapacity(index, length + 4);
        return this.buffer.putStringAscii(index + this.offset, value, byteOrder);
    }

    public String getStringWithoutLengthAscii(int index, int length) {
        return this.buffer.getStringWithoutLengthAscii(index + this.offset, length);
    }

    public int getStringWithoutLengthAscii(int index, int length, Appendable appendable) {
        return this.buffer.getStringWithoutLengthAscii(index + this.offset, length, appendable);
    }

    public int putStringWithoutLengthAscii(int index, String value) {
        int length = value != null ? value.length() : 0;
        this.ensureCapacity(index, length);
        return this.buffer.putStringWithoutLengthAscii(index + this.offset, value);
    }

    public int putStringWithoutLengthAscii(int index, String value, int valueOffset, int length) {
        int len = value != null ? Math.min(value.length() - valueOffset, length) : 0;
        this.ensureCapacity(index, len);
        return this.buffer.putStringWithoutLengthAscii(index + this.offset, value, valueOffset, length);
    }

    public String getStringUtf8(int index) {
        return this.buffer.getStringUtf8(index + this.offset);
    }

    public String getStringUtf8(int index, ByteOrder byteOrder) {
        return this.buffer.getStringUtf8(index + this.offset, byteOrder);
    }

    public String getStringUtf8(int index, int length) {
        return this.buffer.getStringUtf8(index + this.offset, length);
    }

    public int putStringUtf8(int index, String value) {
        return this.putStringUtf8(index, value, Integer.MAX_VALUE);
    }

    public int putStringUtf8(int index, String value, ByteOrder byteOrder) {
        return this.putStringUtf8(index, value, byteOrder, Integer.MAX_VALUE);
    }

    public int putStringUtf8(int index, String value, int maxEncodedLength) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedLength) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedLength);
        }
        this.ensureCapacity(index, 4 + bytes.length);
        this.buffer.putInt(index + this.offset, bytes.length);
        this.buffer.putBytes(index + this.offset + 4, bytes);
        return 4 + bytes.length;
    }

    public int putStringUtf8(int index, String value, ByteOrder byteOrder, int maxEncodedLength) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedLength) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedLength);
        }
        this.ensureCapacity(index, 4 + bytes.length);
        int bits = bytes.length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        this.buffer.putInt(index + this.offset, bits);
        this.buffer.putBytes(index + this.offset + 4, bytes);
        return 4 + bytes.length;
    }

    public String getStringWithoutLengthUtf8(int index, int length) {
        return this.buffer.getStringWithoutLengthUtf8(index + this.offset, length);
    }

    public int putStringWithoutLengthUtf8(int index, String value) {
        byte[] bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        this.ensureCapacity(index, bytes.length);
        this.buffer.putBytes(index + this.offset, bytes);
        return bytes.length;
    }

    public int parseNaturalIntAscii(int index, int length) {
        return this.buffer.parseNaturalIntAscii(index + this.offset, length);
    }

    public long parseNaturalLongAscii(int index, int length) {
        return this.buffer.parseNaturalLongAscii(index + this.offset, length);
    }

    public int parseIntAscii(int index, int length) {
        return this.buffer.parseIntAscii(index + this.offset, length);
    }

    public long parseLongAscii(int index, int length) {
        return this.buffer.parseLongAscii(index + this.offset, length);
    }

    public int putIntAscii(int index, int value) {
        int i;
        if (value == 0) {
            this.putByte(index, (byte)48);
            return 1;
        }
        if (value == Integer.MIN_VALUE) {
            this.putBytes(index, AsciiEncoding.MIN_INTEGER_VALUE);
            return AsciiEncoding.MIN_INTEGER_VALUE.length;
        }
        int start = index;
        int quotient = value;
        int length = 1;
        if (value < 0) {
            this.putByte(index, (byte)45);
            start = index + 1;
            ++length;
            quotient = -value;
        }
        this.ensureCapacity(index, length += i);
        for (i = AsciiEncoding.endOffset((int)quotient); i >= 0; --i) {
            int remainder = quotient % 10;
            quotient /= 10;
            this.buffer.putByte(i + this.offset + start, (byte)(48 + remainder));
        }
        return length;
    }

    public int putNaturalIntAscii(int index, int value) {
        int i;
        if (value == 0) {
            this.putByte(index, (byte)48);
            return 1;
        }
        int length = i + 1;
        this.ensureCapacity(index, length);
        int quotient = value;
        for (i = AsciiEncoding.endOffset((int)value); i >= 0; --i) {
            int remainder = quotient % 10;
            quotient /= 10;
            this.buffer.putByte(i + this.offset + index, (byte)(48 + remainder));
        }
        return length;
    }

    public void putNaturalPaddedIntAscii(int offset, int length, int value) {
        int end = offset + length;
        int remainder = value;
        for (int index = end - 1; index >= offset; --index) {
            int digit = remainder % 10;
            remainder /= 10;
            this.putByte(index, (byte)(48 + digit));
        }
        if (remainder != 0) {
            throw new NumberFormatException(String.format("Cannot write %d in %d bytes", value, length));
        }
    }

    public int putNaturalIntAsciiFromEnd(int value, int endExclusive) {
        int index = endExclusive;
        for (int remainder = value; remainder > 0; remainder /= 10) {
            int digit = remainder % 10;
            this.putByte(--index, (byte)(48 + digit));
        }
        return index;
    }

    public int putNaturalLongAscii(int index, long value) {
        int i;
        if (value == 0L) {
            this.putByte(index, (byte)48);
            return 1;
        }
        int length = i + 1;
        this.ensureCapacity(index, length);
        long quotient = value;
        for (i = AsciiEncoding.endOffset((long)value); i >= 0; --i) {
            long remainder = quotient % 10L;
            quotient /= 10L;
            this.buffer.putByte(i + this.offset + index, (byte)(48L + remainder));
        }
        return length;
    }

    public int putLongAscii(int index, long value) {
        int i;
        if (value == 0L) {
            this.putByte(index, (byte)48);
            return 1;
        }
        if (value == Long.MIN_VALUE) {
            this.putBytes(index, AsciiEncoding.MIN_LONG_VALUE);
            return AsciiEncoding.MIN_LONG_VALUE.length;
        }
        int start = index;
        long quotient = value;
        int length = 1;
        if (value < 0L) {
            this.putByte(index, (byte)45);
            start = index + 1;
            ++length;
            quotient = -value;
        }
        this.ensureCapacity(index, length += i);
        for (i = AsciiEncoding.endOffset((long)quotient); i >= 0; --i) {
            long remainder = quotient % 10L;
            quotient /= 10L;
            this.buffer.putByte(i + this.offset + start, (byte)(48L + remainder));
        }
        return length;
    }

    public void ensureCapacity(int index, int length) {
        long requiredCapacity;
        if (this.buffer == null) {
            throw new IndexOutOfBoundsException("no buffer wrapped hence capacity is 0");
        }
        if (index >= 0 && length >= 0) {
            requiredCapacity = (long)index + (long)this.offset + (long)length;
            if (requiredCapacity <= (long)this.buffer.capacity()) {
                return;
            }
            if (requiredCapacity > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("required capacity exceeds maximum: " + requiredCapacity + " > " + Integer.MAX_VALUE);
            }
        } else {
            throw new IndexOutOfBoundsException("negative value: index=" + index + " length=" + length);
        }
        this.buffer.checkLimit((int)(requiredCapacity - 1L));
    }

    public void boundsCheck(int index, int length) {
        this.buffer.boundsCheck(index, length);
    }

    public int wrapAdjustment() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            ExpandableDirectBuffer that = (ExpandableDirectBuffer)obj;
            return this.compareTo((DirectBuffer)that) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public int compareTo(DirectBuffer that) {
        return this.buffer.compareTo((Object)that);
    }

    public String toString() {
        return "ExpandableDirectBuffer{buffer=" + this.buffer + ", offset=" + this.offset + '}';
    }
}

