/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.log;

import org.agrona.DirectBuffer;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.flyweight.Flags;
import org.tools4j.elara.flyweight.FlyweightEvent;
import org.tools4j.elara.log.MessageLog;

public class CommittedEventPoller
implements MessageLog.Poller {
    private final MessageLog.Poller aheadPoller;
    private final MessageLog.Poller eventPoller;
    private final LookAheadState aheadState = new LookAheadState();

    public CommittedEventPoller(MessageLog eventLog) {
        this.aheadPoller = eventLog.poller();
        this.eventPoller = eventLog.poller();
    }

    public CommittedEventPoller(MessageLog eventLog, String id) {
        this.eventPoller = eventLog.poller(id);
        this.aheadPoller = eventLog.poller();
        this.aheadPoller.moveTo(this.eventPoller.entryId());
    }

    @Override
    public long entryId() {
        return this.eventPoller.entryId();
    }

    @Override
    public MessageLog.Poller moveToStart() {
        this.aheadPoller.moveToStart();
        this.eventPoller.moveToStart();
        this.aheadState.reset();
        return this;
    }

    @Override
    public MessageLog.Poller moveToEnd() {
        while (this.poll(event -> MessageLog.Handler.Result.POLL) > 0) {
        }
        return this;
    }

    @Override
    public boolean moveToNext() {
        long entryId = this.entryId();
        while (this.poll(event -> MessageLog.Handler.Result.POLL) > 0) {
            if (this.entryId() == entryId) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToPrevious() {
        return this.eventPoller.moveToPrevious();
    }

    @Override
    public boolean moveTo(long entryId) {
        long curHeadId = this.aheadPoller.entryId();
        if (!this.aheadPoller.moveTo(entryId)) {
            this.aheadPoller.moveTo(curHeadId);
            return false;
        }
        byte lastEventFlags = this.aheadState.lastEventFlags;
        this.aheadState.reset();
        while (this.aheadPoller.poll(this.aheadState) > 0) {
            if (this.aheadState.isCommit()) {
                this.eventPoller.moveTo(entryId);
                return true;
            }
            if (!this.aheadState.isRollback()) continue;
        }
        this.aheadState.lastEventFlags = lastEventFlags;
        this.aheadPoller.moveTo(curHeadId);
        return false;
    }

    @Override
    public int poll(MessageLog.Handler handler) {
        if (this.eventPoller.entryId() == this.aheadPoller.entryId()) {
            this.aheadState.reset();
        }
        if (this.aheadState.isCommit()) {
            return this.eventPoller.poll(handler);
        }
        if (this.aheadState.isRollback()) {
            this.eventPoller.moveTo(this.aheadPoller.entryId());
            this.aheadState.reset();
        }
        return this.aheadPoller.poll(this.aheadState);
    }

    private static class LookAheadState
    implements MessageLog.Handler {
        byte lastEventFlags;
        final FlyweightEvent event = new FlyweightEvent();

        private LookAheadState() {
        }

        @Override
        public MessageLog.Handler.Result onMessage(DirectBuffer buffer) {
            this.onEvent(this.event.init(buffer, 0));
            return MessageLog.Handler.Result.POLL;
        }

        void onEvent(Event event) {
            this.lastEventFlags = event.flags().value();
        }

        void reset() {
            this.lastEventFlags = 0;
        }

        boolean isCommit() {
            return Flags.isCommit(this.lastEventFlags);
        }

        boolean isRollback() {
            return Flags.isRollback(this.lastEventFlags);
        }
    }
}

