/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.input;

import java.util.Objects;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.flyweight.FlyweightHeader;
import org.tools4j.elara.input.Receiver;
import org.tools4j.elara.log.ExpandableDirectBuffer;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.time.TimeSource;

public final class DefaultReceiver
implements Receiver.Default {
    private final TimeSource timeSource;
    private final MessageLog.Appender commandLogAppender;
    private final ReceivingContext receivingContext = new ReceivingContext();

    public DefaultReceiver(TimeSource timeSource, MessageLog.Appender commandLogAppender) {
        this.timeSource = Objects.requireNonNull(timeSource);
        this.commandLogAppender = Objects.requireNonNull(commandLogAppender);
    }

    @Override
    public ReceivingContext receivingMessage(int source, long sequence, int type) {
        return this.receivingContext.init(source, sequence, type, this.commandLogAppender.appending());
    }

    private final class ReceivingContext
    implements Receiver.ReceivingContext {
        final ExpandableDirectBuffer buffer = new ExpandableDirectBuffer();
        MessageLog.AppendingContext context;

        private ReceivingContext() {
        }

        ReceivingContext init(int source, long sequence, int type, MessageLog.AppendingContext context) {
            if (this.context != null) {
                this.abort();
                throw new IllegalStateException("Receiving context not closed");
            }
            this.context = Objects.requireNonNull(context);
            this.buffer.wrap(context.buffer(), 32);
            FlyweightHeader.writeTo(source, type, sequence, DefaultReceiver.this.timeSource.currentTime(), (byte)0, (short)Short.MIN_VALUE, 0, context.buffer(), 0);
            return this;
        }

        MessageLog.AppendingContext unclosedContext() {
            if (this.context != null) {
                return this.context;
            }
            throw new IllegalStateException("Receiving context is closed");
        }

        @Override
        public MutableDirectBuffer buffer() {
            this.unclosedContext();
            return this.buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(int length) {
            if (length < 0) {
                throw new IllegalArgumentException("Length cannot be negative: " + length);
            }
            this.buffer.unwrap();
            try (MessageLog.AppendingContext ac = this.unclosedContext();){
                if (length > 0) {
                    ac.buffer().putInt(28, length);
                }
                ac.commit(32 + length);
            }
            finally {
                this.context = null;
            }
        }

        @Override
        public void abort() {
            if (this.context != null) {
                this.buffer.unwrap();
                try {
                    this.context.abort();
                }
                finally {
                    this.context = null;
                }
            }
        }

        @Override
        public boolean isClosed() {
            return this.context == null;
        }
    }
}

