/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.handler;

import java.util.Objects;
import org.tools4j.elara.application.ExceptionHandler;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.handler.OutputHandler;
import org.tools4j.elara.output.CommandLoopback;
import org.tools4j.elara.output.Output;

public class DefaultOutputHandler
implements OutputHandler {
    private final Output output;
    private final CommandLoopback commandLoopback;
    private final ExceptionHandler exceptionHandler;

    public DefaultOutputHandler(Output output, CommandLoopback commandLoopback, ExceptionHandler exceptionHandler) {
        this.output = Objects.requireNonNull(output);
        this.commandLoopback = Objects.requireNonNull(commandLoopback);
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
    }

    @Override
    public Output.Ack publish(Event event, boolean replay, int retry) {
        try {
            return this.output.publish(event, replay, retry, this.commandLoopback);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleEventOutputException(event, t);
            return Output.Ack.COMMIT;
        }
    }
}

