/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.handler;

import java.util.Objects;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.application.DuplicateHandler;
import org.tools4j.elara.application.ExceptionHandler;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.handler.CommandHandler;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.elara.route.DefaultEventRouter;

public class DefaultCommandHandler
implements CommandHandler {
    private final BaseState baseState;
    private final DefaultEventRouter eventRouter;
    private final CommandProcessor commandProcessor;
    private final ExceptionHandler exceptionHandler;
    private final DuplicateHandler duplicateHandler;

    public DefaultCommandHandler(BaseState baseState, DefaultEventRouter eventRouter, CommandProcessor commandProcessor, ExceptionHandler exceptionHandler, DuplicateHandler duplicateHandler) {
        this.baseState = Objects.requireNonNull(baseState);
        this.eventRouter = Objects.requireNonNull(eventRouter);
        this.commandProcessor = Objects.requireNonNull(commandProcessor);
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
        this.duplicateHandler = Objects.requireNonNull(duplicateHandler);
    }

    @Override
    public MessageLog.Handler.Result onCommand(Command command) {
        if (this.baseState.allEventsAppliedFor(command.id())) {
            this.skipCommand(command);
            return MessageLog.Handler.Result.POLL;
        }
        if (this.baseState.processCommands()) {
            this.processCommand(command);
            return MessageLog.Handler.Result.POLL;
        }
        return MessageLog.Handler.Result.PEEK;
    }

    private void processCommand(Command command) {
        this.eventRouter.start(command);
        try {
            this.commandProcessor.onCommand(command, this.eventRouter);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleCommandProcessorException(command, t);
        }
        this.eventRouter.complete();
    }

    private void skipCommand(Command command) {
        try {
            this.duplicateHandler.skipCommandProcessing(command);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleCommandProcessorException(command, t);
        }
    }
}

