/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.flyweight;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.tools4j.elara.flyweight.Flags;
import org.tools4j.elara.flyweight.Flyweight;
import org.tools4j.elara.flyweight.Frame;
import org.tools4j.elara.flyweight.Header;
import org.tools4j.elara.flyweight.Version;

public class FlyweightHeader
implements Flyweight<FlyweightHeader>,
Header,
Frame {
    private final MutableDirectBuffer header = new UnsafeBuffer(0L, 0);

    public FlyweightHeader init(int source, int type, long sequence, long time, byte flags, short index, int payloadLSize, MutableDirectBuffer dst, int dstOffset) {
        FlyweightHeader.writeTo(source, type, sequence, time, flags, index, payloadLSize, dst, dstOffset);
        return this.initSilent((DirectBuffer)dst, dstOffset);
    }

    public FlyweightHeader init(Header header, MutableDirectBuffer dst, int dstOffset) {
        return this.init(header.source(), header.type(), header.sequence(), header.time(), header.flags(), header.index(), header.payloadSize(), dst, dstOffset);
    }

    @Override
    public FlyweightHeader init(DirectBuffer src, int srcOffset) {
        int length = src.capacity() - srcOffset;
        if (length < 32) {
            throw new IllegalArgumentException("Invalid frame header, expected min length + 32 but found only " + length);
        }
        Version.validate(src.getByte(srcOffset + 24));
        return this.initSilent(src, srcOffset);
    }

    private FlyweightHeader initSilent(DirectBuffer src, int srcOffset) {
        this.header.wrap(src, srcOffset, 32);
        return this;
    }

    public boolean valid() {
        return this.header.capacity() >= 32;
    }

    public FlyweightHeader reset() {
        this.header.wrap(0L, 0);
        return this;
    }

    @Override
    public Header header() {
        return this;
    }

    @Override
    public int source() {
        return this.header.getInt(0);
    }

    @Override
    public int type() {
        return this.header.getInt(4);
    }

    @Override
    public long sequence() {
        return this.header.getLong(8);
    }

    @Override
    public long time() {
        return this.header.getLong(16);
    }

    @Override
    public short version() {
        return (short)(0xFF & this.header.getByte(24));
    }

    @Override
    public byte flags() {
        return this.header.getByte(25);
    }

    @Override
    public short index() {
        return this.header.getShort(26);
    }

    @Override
    public int payloadSize() {
        return this.header.getInt(28);
    }

    @Override
    public int writeTo(MutableDirectBuffer dst, int dstOffset) {
        dst.putBytes(dstOffset + 0, (DirectBuffer)this.header, 0, 32);
        return 32;
    }

    public static int writeTo(int source, int type, long sequence, long time, byte flags, short index, int payloadLSize, MutableDirectBuffer dst, int dstOffset) {
        dst.putInt(dstOffset + 0, source);
        dst.putInt(dstOffset + 4, type);
        dst.putLong(dstOffset + 8, sequence);
        dst.putLong(dstOffset + 16, time);
        dst.putByte(dstOffset + 24, (byte)2);
        dst.putByte(dstOffset + 25, flags);
        dst.putShort(dstOffset + 26, index);
        dst.putInt(dstOffset + 28, payloadLSize);
        return 32;
    }

    public String toString() {
        return this.valid() ? "FlyweightHeader{source=" + this.source() + ", type=" + this.type() + ", sequence=" + this.sequence() + ", time=" + this.time() + ", version=" + this.version() + ", flags=" + Flags.toString(this.flags()) + ", index=" + this.index() + ", payload-size=" + this.payloadSize() + '}' : "FlyweightHeader";
    }
}

