/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.factory;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.agrona.collections.Object2ObjectHashMap;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.factory.ApplierFactory;
import org.tools4j.elara.factory.DefaultApplierFactory;
import org.tools4j.elara.factory.DefaultInputFactory;
import org.tools4j.elara.factory.DefaultOutputFactory;
import org.tools4j.elara.factory.DefaultPluginFactory;
import org.tools4j.elara.factory.DefaultProcessorFactory;
import org.tools4j.elara.factory.DefaultRunnerFactory;
import org.tools4j.elara.factory.InputFactory;
import org.tools4j.elara.factory.OutputFactory;
import org.tools4j.elara.factory.PluginFactory;
import org.tools4j.elara.factory.ProcessorFactory;
import org.tools4j.elara.factory.RunnerFactory;
import org.tools4j.elara.factory.Singletons;
import org.tools4j.elara.handler.CommandHandler;
import org.tools4j.elara.handler.EventHandler;
import org.tools4j.elara.handler.OutputHandler;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.input.Receiver;
import org.tools4j.elara.input.SequenceGenerator;
import org.tools4j.elara.output.CommandLoopback;
import org.tools4j.elara.output.Output;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.nobark.loop.LoopCondition;
import org.tools4j.nobark.loop.Step;

public class DefaultSingletons
implements Singletons {
    private final RunnerFactory runnerFactory;
    private final InputFactory inputFactory;
    private final ProcessorFactory processorFactory;
    private final ApplierFactory applierFactory;
    private final OutputFactory outputFactory;
    private final PluginFactory pluginFactory;
    private final Map<String, Object> instanceByName = new Object2ObjectHashMap(64, 0.55f);

    public DefaultSingletons(Configuration configuration, Supplier<? extends Singletons> singletonsSupplier) {
        this(configuration, singletonsSupplier, DefaultRunnerFactory::new, DefaultInputFactory::new, DefaultProcessorFactory::new, DefaultApplierFactory::new, DefaultOutputFactory::new, DefaultPluginFactory::new);
    }

    public DefaultSingletons(Configuration configuration, Supplier<? extends Singletons> singletonsSupplier, Singletons.FactorySupplier<? extends RunnerFactory> runnerFactorySupplier, Singletons.FactorySupplier<? extends InputFactory> inputFactorySupplier, Singletons.FactorySupplier<? extends ProcessorFactory> processorFactorySupplier, Singletons.FactorySupplier<? extends ApplierFactory> applierFactorySupplier, Singletons.FactorySupplier<? extends OutputFactory> outputFactorySupplier, Singletons.FactorySupplier<? extends PluginFactory> pluginFactorySupplier) {
        Configuration.validate(configuration);
        this.runnerFactory = runnerFactorySupplier.supply(configuration, singletonsSupplier);
        this.inputFactory = inputFactorySupplier.supply(configuration, singletonsSupplier);
        this.processorFactory = processorFactorySupplier.supply(configuration, singletonsSupplier);
        this.applierFactory = applierFactorySupplier.supply(configuration, singletonsSupplier);
        this.outputFactory = outputFactorySupplier.supply(configuration, singletonsSupplier);
        this.pluginFactory = pluginFactorySupplier.supply(configuration, singletonsSupplier);
    }

    private <T, S> T getOrCreate(String name, Class<T> type, S source, Function<? super S, ? extends T> factory) {
        Object value = this.instanceByName.get(name);
        if (value == null) {
            value = factory.apply(source);
            this.instanceByName.put(name, value);
        }
        return type.cast(value);
    }

    @Override
    public Runnable initStep() {
        return this.getOrCreate("initStep", Runnable.class, this.runnerFactory, RunnerFactory::initStep);
    }

    @Override
    public LoopCondition runningCondition() {
        return this.getOrCreate("runningCondition", LoopCondition.class, this.runnerFactory, RunnerFactory::runningCondition);
    }

    @Override
    public Step dutyCycleStep() {
        return this.getOrCreate("dutyCycleStep", Step.class, this.runnerFactory, RunnerFactory::dutyCycleStep);
    }

    @Override
    public Step dutyCycleExtraStep() {
        return this.getOrCreate("dutyCycleExtraStep", Step.class, this.runnerFactory, RunnerFactory::dutyCycleExtraStep);
    }

    @Override
    public Step[] dutyCycleWithExtraSteps() {
        return this.getOrCreate("dutyCycleWithExtraSteps", Step[].class, this.runnerFactory, RunnerFactory::dutyCycleWithExtraSteps);
    }

    @Override
    public Receiver receiver() {
        return this.getOrCreate("receiver", Receiver.class, this.inputFactory, InputFactory::receiver);
    }

    @Override
    public Input[] inputs() {
        return this.getOrCreate("inputs", Input[].class, this.inputFactory, InputFactory::inputs);
    }

    @Override
    public Step sequencerStep() {
        return this.getOrCreate("sequencerStep", Step.class, this.inputFactory, InputFactory::sequencerStep);
    }

    @Override
    public CommandProcessor commandProcessor() {
        return this.getOrCreate("commandProcessor", CommandProcessor.class, this.processorFactory, ProcessorFactory::commandProcessor);
    }

    @Override
    public CommandHandler commandHandler() {
        return this.getOrCreate("commandHandler", CommandHandler.class, this.processorFactory, ProcessorFactory::commandHandler);
    }

    @Override
    public Step commandPollerStep() {
        return this.getOrCreate("commandPollerStep", Step.class, this.processorFactory, ProcessorFactory::commandPollerStep);
    }

    @Override
    public EventApplier eventApplier() {
        return this.getOrCreate("eventApplier", EventApplier.class, this.applierFactory, ApplierFactory::eventApplier);
    }

    @Override
    public EventHandler eventHandler() {
        return this.getOrCreate("eventHandler", EventHandler.class, this.applierFactory, ApplierFactory::eventHandler);
    }

    @Override
    public Step eventPollerStep() {
        return this.getOrCreate("eventPollerStep", Step.class, this.applierFactory, ApplierFactory::eventPollerStep);
    }

    @Override
    public Output output() {
        return this.getOrCreate("output", Output.class, this.outputFactory, OutputFactory::output);
    }

    @Override
    public SequenceGenerator loopbackSequenceGenerator() {
        return this.getOrCreate("loopbackSequenceGenerator", SequenceGenerator.class, this.outputFactory, OutputFactory::loopbackSequenceGenerator);
    }

    @Override
    public CommandLoopback commandLoopback() {
        return this.getOrCreate("commandLoopback", CommandLoopback.class, this.outputFactory, OutputFactory::commandLoopback);
    }

    @Override
    public OutputHandler outputHandler() {
        return this.getOrCreate("outputHandler", OutputHandler.class, this.outputFactory, OutputFactory::outputHandler);
    }

    @Override
    public Step outputStep() {
        return this.getOrCreate("outputStep", Step.class, this.outputFactory, OutputFactory::outputStep);
    }

    @Override
    public BaseState.Mutable baseState() {
        return this.getOrCreate("baseState", BaseState.Mutable.class, this.pluginFactory, PluginFactory::baseState);
    }

    @Override
    public Plugin.Configuration[] plugins() {
        return this.getOrCreate("plugins", Plugin.Configuration[].class, this.pluginFactory, PluginFactory::plugins);
    }
}

