/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.tools4j.elara.factory.RunnerFactory;
import org.tools4j.elara.factory.Singletons;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.init.ExecutionType;
import org.tools4j.elara.loop.DutyCycleStep;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.nobark.loop.ComposableStep;
import org.tools4j.nobark.loop.LoopCondition;
import org.tools4j.nobark.loop.Step;

public class DefaultRunnerFactory
implements RunnerFactory {
    private final Configuration configuration;
    private final Supplier<? extends Singletons> singletons;

    public DefaultRunnerFactory(Configuration configuration, Supplier<? extends Singletons> singletons) {
        this.configuration = Objects.requireNonNull(configuration);
        this.singletons = Objects.requireNonNull(singletons);
    }

    @Override
    public Runnable initStep() {
        List<Step> pluginSteps = this.pluginSteps(ExecutionType.INIT_ONCE_ONLY);
        List<Step> extraSteps = this.configuration.dutyCycleExtraSteps(ExecutionType.INIT_ONCE_ONLY);
        Step step = DefaultRunnerFactory.compositeStep(pluginSteps, extraSteps);
        return () -> ((Step)step).perform();
    }

    @Override
    public LoopCondition runningCondition() {
        return workDone -> true;
    }

    @Override
    public Step dutyCycleStep() {
        return new DutyCycleStep(this.singletons.get().sequencerStep(), this.singletons.get().commandPollerStep(), this.singletons.get().eventPollerStep(), this.singletons.get().outputStep(), this.singletons.get().dutyCycleExtraStep());
    }

    @Override
    public Step dutyCycleExtraStep() {
        List<Step> pluginSteps = this.pluginSteps(ExecutionType.ALWAYS_WHEN_EVENTS_APPLIED);
        List<Step> extraSteps = this.configuration.dutyCycleExtraSteps(ExecutionType.ALWAYS_WHEN_EVENTS_APPLIED);
        return DefaultRunnerFactory.compositeStep(pluginSteps, extraSteps);
    }

    @Override
    public Step[] dutyCycleWithExtraSteps() {
        int i;
        List<Step> pluginStepsAlways = this.pluginSteps(ExecutionType.ALWAYS);
        List<Step> extraStepsAlways = this.configuration.dutyCycleExtraSteps(ExecutionType.ALWAYS);
        Step[] dutyCycle = new Step[1 + pluginStepsAlways.size() + extraStepsAlways.size()];
        dutyCycle[0] = this.singletons.get().dutyCycleStep();
        int offset = 1;
        for (i = 0; i < pluginStepsAlways.size(); ++i) {
            dutyCycle[offset + i] = pluginStepsAlways.get(i);
        }
        offset = 1 + pluginStepsAlways.size();
        for (i = 0; i < extraStepsAlways.size(); ++i) {
            dutyCycle[offset + i] = extraStepsAlways.get(i);
        }
        return dutyCycle;
    }

    private List<Step> pluginSteps(ExecutionType executionType) {
        Plugin.Configuration[] plugins = this.singletons.get().plugins();
        if (plugins.length == 0) {
            return Collections.emptyList();
        }
        BaseState.Mutable baseState = this.singletons.get().baseState();
        ArrayList<Step> steps = new ArrayList<Step>(plugins.length);
        for (Plugin.Configuration plugin : plugins) {
            steps.add(plugin.step(baseState, executionType));
        }
        return steps;
    }

    private static Step compositeStep(List<Step> pluginSteps, List<Step> extraSteps) {
        if (pluginSteps.isEmpty() && extraSteps.isEmpty()) {
            return Step.NO_OP;
        }
        Step[] allExtraSteps = new Step[pluginSteps.size() + extraSteps.size()];
        for (int i = 0; i < pluginSteps.size(); ++i) {
            allExtraSteps[i] = pluginSteps.get(i);
        }
        int off = pluginSteps.size();
        for (int i = 0; i < extraSteps.size(); ++i) {
            allExtraSteps[off + i] = extraSteps.get(i);
        }
        return ComposableStep.composite((Step[])allExtraSteps);
    }
}

