/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.factory;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.tools4j.elara.factory.PluginFactory;
import org.tools4j.elara.factory.Singletons;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.plugin.api.Plugins;
import org.tools4j.elara.plugin.base.BasePlugin;
import org.tools4j.elara.plugin.base.BaseState;

public class DefaultPluginFactory
implements PluginFactory {
    private static final Plugin.Configuration[] EMPTY_PLUGIN_CONFIGURATIONS = new Plugin.Configuration[0];
    private final Configuration configuration;
    private final Supplier<? extends Singletons> singletons;

    public DefaultPluginFactory(Configuration configuration, Supplier<? extends Singletons> singletons) {
        this.configuration = Objects.requireNonNull(configuration);
        this.singletons = Objects.requireNonNull(singletons);
    }

    @Override
    public Plugin.Configuration[] plugins() {
        List<Plugin.Configuration> plugins = this.configuration.plugins();
        boolean basePluginFound = false;
        for (int i = 0; i < plugins.size(); ++i) {
            basePluginFound |= plugins.get(i) instanceof BasePlugin.BaseConfiguration;
        }
        if (basePluginFound) {
            return this.configuration.plugins().toArray(EMPTY_PLUGIN_CONFIGURATIONS);
        }
        Plugin.Configuration[] pluginsWithBasePlugin = new Plugin.Configuration[plugins.size() + 1];
        plugins.toArray(pluginsWithBasePlugin);
        pluginsWithBasePlugin[pluginsWithBasePlugin.length - 1] = Plugins.basePlugin().configuration(this.configuration, BasePlugin.BaseConfiguration.createDefaultBaseState());
        return pluginsWithBasePlugin;
    }

    @Override
    public BaseState.Mutable baseState() {
        for (Plugin.Configuration plugin : this.singletons.get().plugins()) {
            if (!(plugin instanceof BasePlugin.BaseConfiguration)) continue;
            return ((BasePlugin.BaseConfiguration)plugin).baseState();
        }
        throw new IllegalStateException("Plugins must contain BaseConfiguration instance");
    }
}

