/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.factory;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.factory.OutputFactory;
import org.tools4j.elara.factory.Singletons;
import org.tools4j.elara.handler.DefaultOutputHandler;
import org.tools4j.elara.handler.OutputHandler;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.input.SequenceGenerator;
import org.tools4j.elara.input.SimpleSequenceGenerator;
import org.tools4j.elara.loop.OutputStep;
import org.tools4j.elara.output.CommandLoopback;
import org.tools4j.elara.output.CompositeOutput;
import org.tools4j.elara.output.DefaultCommandLoopback;
import org.tools4j.elara.output.Output;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.nobark.loop.Step;

public class DefaultOutputFactory
implements OutputFactory {
    private final Configuration configuration;
    private final Supplier<? extends Singletons> singletons;

    public DefaultOutputFactory(Configuration configuration, Supplier<? extends Singletons> singletons) {
        this.configuration = Objects.requireNonNull(configuration);
        this.singletons = Objects.requireNonNull(singletons);
    }

    @Override
    public Output output() {
        Plugin.Configuration[] plugins = this.singletons.get().plugins();
        if (plugins.length == 0) {
            return this.configuration.output();
        }
        BaseState.Mutable baseState = this.singletons.get().baseState();
        Output[] outputs = new Output[plugins.length + 1];
        int count = 0;
        for (Plugin.Configuration plugin : plugins) {
            outputs[count] = plugin.output(baseState);
            if (outputs[count] == EventApplier.NOOP) continue;
            ++count;
        }
        if (count == 0) {
            return this.configuration.output();
        }
        outputs[count++] = this.configuration.output();
        return new CompositeOutput(count == outputs.length ? outputs : Arrays.copyOf(outputs, count), this.configuration.exceptionHandler());
    }

    @Override
    public SequenceGenerator loopbackSequenceGenerator() {
        return new SimpleSequenceGenerator(this.configuration.timeSource().currentTime());
    }

    @Override
    public CommandLoopback commandLoopback() {
        return new DefaultCommandLoopback(this.configuration.commandLog().appender(), this.configuration.timeSource(), this.singletons.get().loopbackSequenceGenerator());
    }

    @Override
    public OutputHandler outputHandler() {
        return new DefaultOutputHandler(this.singletons.get().output(), this.singletons.get().commandLoopback(), this.configuration.exceptionHandler());
    }

    @Override
    public Step outputStep() {
        if (this.configuration.output() == Output.NOOP) {
            return Step.NO_OP;
        }
        OutputHandler outputHandler = this.singletons.get().outputHandler();
        try {
            return new OutputStep(outputHandler, this.configuration.eventLog(), "elara-out");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return new OutputStep(outputHandler, this.configuration.eventLog());
        }
    }
}

