/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.tools4j.elara.factory.InputFactory;
import org.tools4j.elara.factory.Singletons;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.input.DefaultReceiver;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.input.Receiver;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.loop.SequencerStep;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.nobark.loop.Step;

public class DefaultInputFactory
implements InputFactory {
    private final Configuration configuration;
    private final Supplier<? extends Singletons> singletons;

    public DefaultInputFactory(Configuration configuration, Supplier<? extends Singletons> singletons) {
        this.configuration = Objects.requireNonNull(configuration);
        this.singletons = Objects.requireNonNull(singletons);
    }

    @Override
    public Input[] inputs() {
        List<Input> inputs = this.configuration.inputs();
        Plugin.Configuration[] plugins = this.singletons.get().plugins();
        if (plugins.length == 0) {
            return inputs.toArray(Plugin.NO_INPUTS);
        }
        BaseState.Mutable baseState = this.singletons.get().baseState();
        ArrayList<Input> allInputs = new ArrayList<Input>(inputs.size() + 3 * plugins.length);
        allInputs.addAll(inputs);
        for (Plugin.Configuration plugin : plugins) {
            allInputs.addAll(Arrays.asList(plugin.inputs(baseState)));
        }
        return allInputs.toArray(Plugin.NO_INPUTS);
    }

    @Override
    public Receiver receiver() {
        MessageLog.Appender commandAppender = this.configuration.commandLog().appender();
        return new DefaultReceiver(this.configuration.timeSource(), commandAppender);
    }

    @Override
    public Step sequencerStep() {
        return new SequencerStep(this.singletons.get().receiver(), this.singletons.get().inputs());
    }
}

