/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.factory;

import java.util.Objects;
import org.tools4j.elara.factory.DefaultSingletons;
import org.tools4j.elara.factory.ElaraFactory;
import org.tools4j.elara.factory.InterceptableSingletons;
import org.tools4j.elara.factory.Singletons;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.plugin.api.Plugin;

public class DefaultElaraFactory
implements ElaraFactory {
    private final Configuration configuration;
    private final Singletons singletons;

    public DefaultElaraFactory(Configuration configuration) {
        this.configuration = Configuration.validate(configuration);
        this.singletons = DefaultElaraFactory.intercept(new DefaultSingletons(configuration, this::singletons));
    }

    private static Singletons intercept(Singletons singletons) {
        Singletons interceptedOrNot = Objects.requireNonNull(singletons);
        for (Plugin.Configuration pluginConfig : singletons.plugins()) {
            InterceptableSingletons intercepted = pluginConfig.interceptOrNull(singletons);
            if (intercepted == null) continue;
            interceptedOrNot = intercepted;
        }
        return interceptedOrNot;
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public Singletons singletons() {
        return this.singletons;
    }
}

