/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.input.SequenceGenerator;
import org.tools4j.elara.output.Output;
import org.tools4j.elara.plugin.timer.TimerCommands;
import org.tools4j.elara.plugin.timer.TimerEvents;
import org.tools4j.elara.plugin.timer.TimerState;
import org.tools4j.elara.time.TimeSource;

public final class TimerTrigger {
    private final TimerState timerState;
    private final MutableDirectBuffer buffer = new ExpandableDirectByteBuffer(20);
    private long nextTriggerTime = Long.MIN_VALUE;

    public TimerTrigger(TimerState timerState) {
        this.timerState = Objects.requireNonNull(timerState);
    }

    public Output asOutput() {
        return (event, replay, loopback) -> {
            int next;
            if (event.time() >= this.nextTriggerTime && (next = this.timerState.indexOfNextDeadline()) >= 0 && this.timerState.deadline(next) <= event.time()) {
                int len = TimerCommands.triggerTimer(this.buffer, 0, this.timerState.id(next), this.timerState.type(next), this.timerState.timeout(next));
                loopback.enqueueCommand(-10, (DirectBuffer)this.buffer, 0, len);
            }
            this.nextTriggerTime = TimerEvents.isTimerEvent(event) ? event.time() : event.time() + 1L;
        };
    }

    public Input asInput(int id, TimeSource timeSource, SequenceGenerator sequenceGenerator) {
        Objects.requireNonNull(timeSource);
        Objects.requireNonNull(sequenceGenerator);
        return Input.create(id, handler -> {
            long time = timeSource.currentTime();
            if (time >= this.nextTriggerTime) {
                int next = this.timerState.indexOfNextDeadline();
                if (next >= 0 && this.timerState.deadline(next) <= time) {
                    long seq = sequenceGenerator.nextSequence();
                    int len = TimerCommands.triggerTimer(this.buffer, 0, this.timerState.id(next), this.timerState.type(next), this.timerState.timeout(next));
                    handler.onMessage(seq, -10, (DirectBuffer)this.buffer, 0, len);
                }
                this.nextTriggerTime = time + 1L;
                return 1;
            }
            return 0;
        });
    }
}

