/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.event.EventRouter;

public enum TimerEvents {

    public static final int TIMER_EXPIRED = -10;
    public static final int TIMER_STARTED = -11;
    public static final int TIMER_STOPPED = -12;

    public static void timerStarted(MutableDirectBuffer payloadBuffer, int offset, long timerId, int timerType, long timeout, EventRouter eventRouter) {
        TimerEvents.timerEvent(payloadBuffer, offset, -11, timerId, timerType, timeout, eventRouter);
    }

    public static void timerStopped(MutableDirectBuffer payloadBuffer, int offset, long timerId, int timerType, long timeout, EventRouter eventRouter) {
        TimerEvents.timerEvent(payloadBuffer, offset, -12, timerId, timerType, timeout, eventRouter);
    }

    public static void timerExpired(Command command, EventRouter eventRouter) {
        if (command.type() != -10) {
            throw new IllegalArgumentException("Expected -10 command but found " + command.type());
        }
        DirectBuffer payload = command.payload();
        eventRouter.routeEvent(-10, payload, 0, payload.capacity());
    }

    private static void timerEvent(MutableDirectBuffer payloadBuffer, int offset, int eventType, long timerId, int timerType, long timeout, EventRouter eventRouter) {
        payloadBuffer.putLong(offset + 0, timerId);
        payloadBuffer.putInt(offset + 8, timerType);
        payloadBuffer.putLong(offset + 12, timeout);
        eventRouter.routeEvent(eventType, (DirectBuffer)payloadBuffer, offset, 20);
    }

    public static long timerId(Event event) {
        return event.payload().getLong(0);
    }

    public static int timerType(Event event) {
        return event.payload().getInt(8);
    }

    public static long timerTimeout(Event event) {
        return event.payload().getLong(12);
    }

    public static boolean isTimerEvent(Event event) {
        switch (event.type()) {
            case -12: 
            case -11: 
            case -10: {
                return true;
            }
        }
        return false;
    }
}

