/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replicate;

import java.util.Arrays;
import org.tools4j.elara.plugin.replicate.ServerConfig;

public class DefaultServerConfig
implements ServerConfig {
    private final int serverId;
    private final int[] serverIds;

    public DefaultServerConfig(int serverId, int ... serverIds) {
        DefaultServerConfig.validateServerId(serverId, serverIds);
        this.serverId = serverId;
        this.serverIds = serverIds;
    }

    private static void validateServerId(int serverId, int ... serverIds) {
        for (int id : serverIds) {
            if (id != serverId) continue;
            return;
        }
        throw new IllegalArgumentException("Server ID " + serverId + " is not in " + Arrays.toString(serverIds));
    }

    @Override
    public int serverId() {
        return this.serverId;
    }

    @Override
    public int serverCount() {
        return this.serverIds.length;
    }

    @Override
    public int serverId(int index) {
        return this.serverIds[index];
    }

    public String toString() {
        return "DefaultServerConfig{serverId=" + this.serverId + ", serverIds=" + Arrays.toString(this.serverIds) + '}';
    }
}

