/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.log;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.tools4j.elara.format.MessagePrinter;
import org.tools4j.elara.log.MessageLog;

public class MessageLogPrinter
implements AutoCloseable {
    private final PrintWriter printWriter;
    private final boolean close;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public MessageLogPrinter() {
        this(System.out, false);
    }

    public MessageLogPrinter(OutputStream outputStream) {
        this(outputStream, true);
    }

    public MessageLogPrinter(OutputStream outputStream, boolean close) {
        this(new OutputStreamWriter(outputStream), close);
    }

    public MessageLogPrinter(Writer writer) {
        this(writer, true);
    }

    public MessageLogPrinter(Writer writer, boolean close) {
        this.printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.close = close;
    }

    public void flush() {
        this.printWriter.flush();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.close) {
                this.printWriter.close();
            } else {
                this.printWriter.flush();
            }
        }
    }

    public <M> void print(MessageLog.Poller<M> poller) {
        this.print(poller, MessagePrinter.DEFAULT);
    }

    public <M> void print(MessageLog.Poller<M> poller, MessagePrinter<? super M> printer) {
        this.print(poller, msg -> true, printer);
    }

    public <M> void print(MessageLog.Poller<M> poller, Predicate<? super M> filter, MessagePrinter<? super M> printer) {
        long[] linePtr = new long[]{0L};
        MessageLog.Handler<Object> handler = message -> {
            long l = linePtr[0];
            linePtr[0] = l + 1L;
            long line = l;
            if (filter.test((Object)message)) {
                printer.print(line, poller.entryId(), message, this.printWriter);
            }
        };
        while (poller.poll(handler) > 0) {
        }
        this.flush();
    }
}

