/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.log;

import java.util.Objects;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.log.Flyweight;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.log.PeekableMessageLog;
import org.tools4j.elara.log.Writable;

public class InMemoryLog<M extends Writable>
implements PeekableMessageLog<M> {
    private final Supplier<? extends Flyweight<? extends M>> flyweightSupplier;
    private final boolean removeOnPoll;
    private Element root;
    private Element last;

    public InMemoryLog(Supplier<? extends Flyweight<? extends M>> flyweightSupplier) {
        this(flyweightSupplier, true);
    }

    public InMemoryLog(Supplier<? extends Flyweight<? extends M>> flyweightSupplier, boolean removeOnPoll) {
        this.last = this.root = new Element();
        this.flyweightSupplier = Objects.requireNonNull(flyweightSupplier);
        this.removeOnPoll = removeOnPoll;
    }

    @Override
    public MessageLog.Appender<M> appender() {
        return message -> {
            MutableDirectBuffer buffer = this.last.buffer;
            this.last = this.last.append();
            message.writeTo(buffer, 0);
        };
    }

    @Override
    public PeekableMessageLog.PeekablePoller<M> poller() {
        return new PeekableMessageLog.PeekablePoller<M>(){
            final Flyweight<? extends M> flyweight;
            Element current;
            long index;
            {
                this.flyweight = (Flyweight)InMemoryLog.this.flyweightSupplier.get();
                this.current = InMemoryLog.this.root;
                this.index = 0L;
            }

            @Override
            public long entryId() {
                return this.index;
            }

            @Override
            public PeekableMessageLog.PeekablePoller<M> moveToStart() {
                this.current = InMemoryLog.this.root;
                this.index = 0L;
                return this;
            }

            @Override
            public PeekableMessageLog.PeekablePoller<M> moveToEnd() {
                while (this.current.next != null) {
                    this.moveToNext();
                }
                return this;
            }

            @Override
            public boolean moveToNext() {
                if (this.current.next != null) {
                    this.doMoveToNext();
                    return true;
                }
                return false;
            }

            @Override
            public boolean moveTo(long entryId) {
                throw new UnsupportedOperationException();
            }

            private void doMoveToNext() {
                this.current = this.current.next;
                ++this.index;
                if (InMemoryLog.this.removeOnPoll) {
                    ((InMemoryLog)InMemoryLog.this).root.next = null;
                    InMemoryLog.this.root = this.current;
                }
            }

            @Override
            public int peekOrPoll(PeekableMessageLog.PeekPollHandler<? super M> handler) {
                if (this.current.next == null) {
                    return 0;
                }
                Writable flyMessage = (Writable)this.flyweight.init((DirectBuffer)this.current.buffer, 0);
                PeekableMessageLog.PeekPollHandler.Result result = handler.onMessage(flyMessage);
                if (result == PeekableMessageLog.PeekPollHandler.Result.POLL) {
                    this.doMoveToNext();
                    return 1;
                }
                return 0;
            }

            @Override
            public int poll(MessageLog.Handler<? super M> handler) {
                if (this.current.next == null) {
                    return 0;
                }
                Writable flyMessage = (Writable)this.flyweight.init((DirectBuffer)this.current.buffer, 0);
                handler.onMessage(flyMessage);
                this.doMoveToNext();
                return 1;
            }
        };
    }

    @Override
    public PeekableMessageLog.PeekablePoller<M> poller(String id) {
        throw new UnsupportedOperationException("tracking poller not supported");
    }

    @Override
    public long size() {
        int size = 0;
        Element e = this.root;
        while (e.next != null) {
            ++size;
            e = e.next;
        }
        return size;
    }

    @Override
    public void close() {
    }

    private static final class Element {
        final MutableDirectBuffer buffer = new ExpandableArrayBuffer();
        Element next;

        private Element() {
        }

        Element append() {
            this.next = new Element();
            return this.next;
        }
    }
}

