/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.log;

import org.tools4j.elara.event.Event;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.log.PeekableMessageLog;

public class CommittedEventPoller
implements PeekableMessageLog.PeekablePoller<Event> {
    private final PeekableMessageLog.PeekablePoller<? extends Event> aheadPoller;
    private final PeekableMessageLog.PeekablePoller<? extends Event> eventPoller;
    private final LookAheadState aheadState = new LookAheadState();

    public CommittedEventPoller(PeekableMessageLog<? extends Event> eventLog) {
        this.aheadPoller = eventLog.poller();
        this.eventPoller = eventLog.poller();
    }

    public CommittedEventPoller(PeekableMessageLog<? extends Event> eventLog, String id) {
        this.eventPoller = eventLog.poller(id);
        this.aheadPoller = eventLog.poller();
        this.aheadPoller.moveTo(this.eventPoller.entryId());
    }

    @Override
    public long entryId() {
        return this.eventPoller.entryId();
    }

    @Override
    public PeekableMessageLog.PeekablePoller<Event> moveToStart() {
        this.aheadPoller.moveToStart();
        this.eventPoller.moveToStart();
        this.aheadState.reset();
        return this;
    }

    @Override
    public PeekableMessageLog.PeekablePoller<Event> moveToEnd() {
        while (this.poll((MessageLog.Handler<? super Event>)((MessageLog.Handler<Event>)event -> {})) > 0) {
        }
        return this;
    }

    @Override
    public boolean moveToNext() {
        long entryId = this.entryId();
        while (this.poll((MessageLog.Handler<? super Event>)((MessageLog.Handler<Event>)event -> {})) > 0) {
            if (this.entryId() == entryId) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveTo(long entryId) {
        long curHeadId = this.aheadPoller.entryId();
        if (!this.aheadPoller.moveTo(entryId)) {
            this.aheadPoller.moveTo(curHeadId);
            return false;
        }
        int lastEventType = this.aheadState.lastEventType;
        this.aheadState.reset();
        while (this.aheadPoller.poll(this.aheadState) > 0) {
            if (this.aheadState.isCommit()) {
                this.eventPoller.moveTo(entryId);
                return true;
            }
            if (!this.aheadState.isRollback()) continue;
        }
        this.aheadState.lastEventType = lastEventType;
        this.aheadPoller.moveTo(curHeadId);
        return false;
    }

    @Override
    public int poll(MessageLog.Handler<? super Event> handler) {
        if (this.eventPoller.entryId() == this.aheadPoller.entryId()) {
            this.aheadState.reset();
        }
        if (this.aheadState.isCommit()) {
            return this.eventPoller.poll(handler);
        }
        if (this.aheadState.isRollback()) {
            this.eventPoller.moveTo(this.aheadPoller.entryId());
            this.aheadState.reset();
        }
        return this.aheadPoller.poll(this.aheadState);
    }

    @Override
    public int peekOrPoll(PeekableMessageLog.PeekPollHandler<? super Event> handler) {
        if (this.eventPoller.entryId() == this.aheadPoller.entryId()) {
            this.aheadState.reset();
        }
        if (this.aheadState.isCommit()) {
            return this.eventPoller.peekOrPoll(handler);
        }
        if (this.aheadState.isRollback()) {
            this.eventPoller.moveTo(this.aheadPoller.entryId());
            this.aheadState.reset();
        }
        return this.aheadPoller.poll(this.aheadState);
    }

    private static class LookAheadState
    implements MessageLog.Handler<Event> {
        int lastEventType;

        private LookAheadState() {
        }

        @Override
        public void onMessage(Event event) {
            this.lastEventType = event.type();
        }

        void reset() {
            this.lastEventType = 0;
        }

        boolean isCommit() {
            return this.lastEventType == -1;
        }

        boolean isRollback() {
            return this.lastEventType == -2;
        }
    }
}

