/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tools4j.elara.application.Application;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.command.CompositeCommandProcessor;
import org.tools4j.elara.event.CompositeEventApplier;
import org.tools4j.elara.init.Context;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.input.SequenceGenerator;
import org.tools4j.elara.input.SimpleSequenceGenerator;
import org.tools4j.elara.output.CompositeOutput;
import org.tools4j.elara.output.Output;
import org.tools4j.elara.plugin.Plugin;
import org.tools4j.elara.plugin.base.BasePlugin;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.elara.time.TimeSource;

final class Plugins {
    final Plugin.Context[] plugins;
    final BaseState.Mutable baseState;
    final SequenceGenerator adminSequenceGenerator;
    final Input[] inputs;
    final Output output;
    final CommandProcessor commandProcessor;
    final EventApplier eventApplier;

    <A extends Application> Plugins(Context context, A application, List<Plugin.Builder<? super A>> pluginBuilders) {
        this.plugins = Plugins.plugins(application, pluginBuilders);
        this.baseState = this.baseState();
        this.adminSequenceGenerator = new SimpleSequenceGenerator();
        this.inputs = Plugins.inputs(context.inputs(), this.baseState, context.timeSource(), this.adminSequenceGenerator, this.plugins);
        this.output = Plugins.output(this.baseState, context, this.plugins);
        this.commandProcessor = Plugins.commandProcessor(this.baseState, application, this.plugins);
        this.eventApplier = Plugins.eventApplier(this.baseState, application, this.plugins);
    }

    private BaseState.Mutable baseState() {
        for (Plugin.Context plugin : this.plugins) {
            if (!(plugin instanceof BasePlugin.BaseContext)) continue;
            return ((BasePlugin.BaseContext)plugin).baseState();
        }
        return BasePlugin.BaseContext.createDefaultBaseStae();
    }

    private static <A extends Application> Plugin.Context[] plugins(A application, List<Plugin.Builder<? super A>> builders) {
        Plugin.Context[] plugins = new Plugin.Context[builders.size()];
        for (int i = 0; i < plugins.length; ++i) {
            plugins[i] = builders.get(i).create(application);
        }
        return plugins;
    }

    private static CommandProcessor commandProcessor(BaseState baseState, Application application, Plugin.Context ... plugins) {
        if (plugins.length == 0) {
            return application.commandProcessor();
        }
        CommandProcessor[] processors = new CommandProcessor[plugins.length + 1];
        int count = 1;
        for (Plugin.Context plugin : plugins) {
            processors[count] = plugin.commandProcessor(baseState);
            if (processors[count] == CommandProcessor.NOOP) continue;
            ++count;
        }
        if (count == 1) {
            return application.commandProcessor();
        }
        processors[0] = application.commandProcessor();
        return new CompositeCommandProcessor(count == processors.length ? processors : Arrays.copyOf(processors, count));
    }

    private static EventApplier eventApplier(BaseState.Mutable baseState, Application application, Plugin.Context ... plugins) {
        if (plugins.length == 0) {
            return application.eventApplier();
        }
        EventApplier[] appliers = new EventApplier[plugins.length + 1];
        int count = 0;
        for (Plugin.Context plugin : plugins) {
            appliers[count] = plugin.eventApplier(baseState);
            if (appliers[count] == EventApplier.NOOP) continue;
            ++count;
        }
        if (count == 0) {
            return application.eventApplier();
        }
        appliers[count++] = application.eventApplier();
        return new CompositeEventApplier(count == appliers.length ? appliers : Arrays.copyOf(appliers, count));
    }

    private static Input[] inputs(List<Input> inputs, BaseState baseState, TimeSource timeSource, SequenceGenerator adminSequenceGenerator, Plugin.Context ... plugins) {
        if (plugins.length == 0) {
            return inputs.toArray(Input.EMPTY_INPUTS);
        }
        ArrayList<Input> allInputs = new ArrayList<Input>(inputs.size() + 3 * plugins.length);
        allInputs.addAll(inputs);
        for (Plugin.Context plugin : plugins) {
            allInputs.addAll(Arrays.asList(plugin.inputs(baseState, timeSource, adminSequenceGenerator)));
        }
        return allInputs.toArray(Input.EMPTY_INPUTS);
    }

    private static Output output(BaseState.Mutable baseState, Context context, Plugin.Context ... plugins) {
        if (plugins.length == 0) {
            return context.output();
        }
        Output[] outputs = new Output[plugins.length + 1];
        int count = 0;
        for (Plugin.Context plugin : plugins) {
            outputs[count] = plugin.output(baseState);
            if (outputs[count] == EventApplier.NOOP) continue;
            ++count;
        }
        if (count == 0) {
            return context.output();
        }
        outputs[count++] = context.output();
        return new CompositeOutput(count == outputs.length ? outputs : Arrays.copyOf(outputs, count));
    }
}

