/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.tools4j.elara.application.Application;
import org.tools4j.elara.application.DuplicateHandler;
import org.tools4j.elara.application.ExceptionHandler;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.handler.InputHandlerFactory;
import org.tools4j.elara.init.Context;
import org.tools4j.elara.init.Plugins;
import org.tools4j.elara.init.Singletons;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.log.InputTrackingAppender;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.log.PeekableMessageLog;
import org.tools4j.elara.loop.CommandPollerStep;
import org.tools4j.elara.loop.DutyCycle;
import org.tools4j.elara.loop.EventPollerStep;
import org.tools4j.elara.loop.SequencerStep;
import org.tools4j.elara.output.Output;
import org.tools4j.elara.plugin.Plugin;
import org.tools4j.elara.time.TimeSource;
import org.tools4j.nobark.run.ThreadLike;

final class DefaultContext
implements Context {
    private static final String DEFAULT_THREAD_NAME = "duty-cycle";
    private final List<Input> inputs = new ArrayList<Input>();
    private Output output = Output.NOOP;
    private PeekableMessageLog<Command> commandLog;
    private MessageLog<Event> eventLog;
    private TimeSource timeSource;
    private ExceptionHandler exceptionHandler = ExceptionHandler.DEFAULT;
    private DuplicateHandler duplicateHandler = DuplicateHandler.DEFAULT;
    private IdleStrategy idleStrategy = new BackoffIdleStrategy(100L, 10L, TimeUnit.MICROSECONDS.toNanos(1L), TimeUnit.MICROSECONDS.toNanos(100L));
    private ThreadFactory threadFactory;

    DefaultContext() {
    }

    @Override
    public List<Input> inputs() {
        return this.inputs;
    }

    @Override
    public Context input(Input input) {
        if (input.id() == -1) {
            throw new IllegalStateException("Input id -1 is reserved for command loopback");
        }
        this.inputs.add(input);
        return this;
    }

    @Override
    public Context input(int id, Input.Poller poller) {
        return this.input(Input.create(id, poller));
    }

    @Override
    public Output output() {
        return this.output;
    }

    @Override
    public Context output(Output output) {
        this.output = Objects.requireNonNull(output);
        return this;
    }

    @Override
    public PeekableMessageLog<Command> commandLog() {
        return this.commandLog;
    }

    @Override
    public Context commandLog(String file) {
        throw new IllegalStateException("not supported yet");
    }

    @Override
    public Context commandLog(PeekableMessageLog<Command> commandLog) {
        this.commandLog = Objects.requireNonNull(commandLog);
        return this;
    }

    @Override
    public MessageLog<Event> eventLog() {
        return this.eventLog;
    }

    @Override
    public Context eventLog(String file) {
        throw new IllegalStateException("not supported yet");
    }

    @Override
    public Context eventLog(MessageLog<Event> eventLog) {
        this.eventLog = Objects.requireNonNull(eventLog);
        return this;
    }

    @Override
    public TimeSource timeSource() {
        return this.timeSource;
    }

    @Override
    public Context timeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
        return this;
    }

    @Override
    public ExceptionHandler exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public Context exceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
        return this;
    }

    @Override
    public DuplicateHandler duplicateHandler() {
        return this.duplicateHandler;
    }

    @Override
    public Context duplicateHandler(DuplicateHandler duplicateHandler) {
        this.duplicateHandler = Objects.requireNonNull(duplicateHandler);
        return this;
    }

    @Override
    public IdleStrategy idleStrategy() {
        return this.idleStrategy;
    }

    @Override
    public Context idleStrategy(IdleStrategy idleStrategy) {
        this.idleStrategy = Objects.requireNonNull(idleStrategy);
        return this;
    }

    @Override
    public ThreadFactory threadFactory() {
        return this.threadFactory;
    }

    @Override
    public Context threadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    @Override
    public Context threadFactory(String threadName) {
        return this.threadFactory(threadName == null ? null : r -> new Thread(null, r, threadName));
    }

    @Override
    public Context validateAndPopulateDefaults() {
        for (int i = 0; i < this.inputs.size(); ++i) {
            for (int j = i + 1; j < this.inputs.size(); ++j) {
                if (this.inputs.get(i).id() != this.inputs.get(j).id()) continue;
                throw new IllegalStateException("Duplicate input id: " + this.inputs.get(i).id());
            }
        }
        if (this.commandLog == null) {
            throw new IllegalStateException("Command log must be set");
        }
        if (this.eventLog == null) {
            throw new IllegalStateException("Event log must be set");
        }
        if (this.timeSource == null) {
            this.timeSource = System::currentTimeMillis;
        }
        if (this.threadFactory == null) {
            this.threadFactory(DEFAULT_THREAD_NAME);
        }
        return this;
    }

    static DutyCycle dutyCycle(Context context, Plugins plugins, Singletons singletons) {
        return new DutyCycle(DefaultContext.sequencerStep(context, plugins), DefaultContext.commandPollerStep(context, plugins, singletons), DefaultContext.eventApplierStep(context, plugins, singletons));
    }

    static InputHandlerFactory inputHandlerFactory(Context context) {
        InputTrackingAppender commandAppender = new InputTrackingAppender(context.commandLog().appender(), context.duplicateHandler(), context.commandLog().poller());
        return new InputHandlerFactory(context.timeSource(), commandAppender);
    }

    static SequencerStep sequencerStep(Context context, Plugins plugins) {
        return new SequencerStep(plugins.baseState, DefaultContext.inputHandlerFactory(context), plugins.inputs);
    }

    static CommandPollerStep commandPollerStep(Context context, Plugins plugins, Singletons singletons) {
        return new CommandPollerStep(plugins.baseState, (PeekableMessageLog.PeekablePoller<? extends Command>)context.commandLog().poller(), singletons.commandHandler);
    }

    static EventPollerStep eventApplierStep(Context context, Plugins plugins, Singletons singletons) {
        return new EventPollerStep(plugins.baseState, context.eventLog().poller(), singletons.eventHandler);
    }

    static org.tools4j.nobark.loop.IdleStrategy idleStrategy(Context context) {
        final IdleStrategy idleStrategy = Objects.requireNonNull(context.idleStrategy());
        return new org.tools4j.nobark.loop.IdleStrategy(){

            public void idle() {
                idleStrategy.idle();
            }

            public void reset() {
                idleStrategy.reset();
            }

            public void idle(boolean workDone) {
                idleStrategy.idle(workDone ? 1 : 0);
            }

            public String toString() {
                return idleStrategy.toString();
            }
        };
    }

    static <A extends Application> ThreadLike start(Context context, A application, List<Plugin.Builder<? super A>> pluginBuilders) {
        context.validateAndPopulateDefaults();
        Plugins plugins = new Plugins(context, application, pluginBuilders);
        Singletons singletons = new Singletons(context, plugins);
        return DefaultContext.dutyCycle(context, plugins, singletons).start(DefaultContext.idleStrategy(context), context.exceptionHandler(), context.threadFactory());
    }
}

