/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.handler;

import java.util.Objects;
import java.util.function.Function;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.flyweight.FlyweightCommand;
import org.tools4j.elara.handler.InputHandler;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.time.TimeSource;

public final class InputHandlerFactory
implements Function<Input, Input.Handler> {
    private final TimeSource timeSource;
    private final MessageLog.Appender<? super Command> commandLogAppender;
    private final MutableDirectBuffer headerBuffer = new ExpandableDirectByteBuffer(32);
    private final FlyweightCommand flyweightCommand = new FlyweightCommand();

    public InputHandlerFactory(TimeSource timeSource, MessageLog.Appender<? super Command> commandLogAppender) {
        this.commandLogAppender = Objects.requireNonNull(commandLogAppender);
        this.timeSource = Objects.requireNonNull(timeSource);
    }

    @Override
    public Input.Handler apply(Input input) {
        return new InputHandler(this.timeSource, input, this.commandLogAppender, this.headerBuffer, this.flyweightCommand);
    }
}

