/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.handler;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.flyweight.FlyweightCommand;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.time.TimeSource;

public final class InputHandler
implements Input.Handler {
    private final TimeSource timeSource;
    private final Input input;
    private final MessageLog.Appender<? super Command> commandLogAppender;
    private final MutableDirectBuffer headerBuffer;
    private final FlyweightCommand flyweightCommand;

    public InputHandler(TimeSource timeSource, Input input, MessageLog.Appender<? super Command> commandLogAppender, MutableDirectBuffer headerBuffer, FlyweightCommand flyweightCommand) {
        this.timeSource = Objects.requireNonNull(timeSource);
        this.input = Objects.requireNonNull(input);
        this.commandLogAppender = Objects.requireNonNull(commandLogAppender);
        this.headerBuffer = Objects.requireNonNull(headerBuffer);
        this.flyweightCommand = Objects.requireNonNull(flyweightCommand);
    }

    @Override
    public void onMessage(long sequence, int type, DirectBuffer buffer, int offset, int length) {
        this.commandLogAppender.append(this.flyweightCommand.init(this.headerBuffer, 0, this.input.id(), sequence, type, this.timeSource.currentTime(), buffer, offset, length));
        this.flyweightCommand.reset();
    }
}

