/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.format;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Objects;
import org.tools4j.elara.format.MessagePrinter;
import org.tools4j.elara.format.ValueFormatter;

public class ParameterizedMessagePrinter<M>
implements MessagePrinter<M> {
    private final String pattern;
    private final ValueFormatter<? super M> formatter;
    private final MessagePrinter<? super M>[] printers;

    public ParameterizedMessagePrinter(String pattern, ValueFormatter<? super M> formatter) {
        this.pattern = Objects.requireNonNull(pattern);
        this.formatter = Objects.requireNonNull(formatter);
        this.printers = this.parse(pattern);
    }

    @Override
    public void print(long line, long entryId, M message, PrintWriter writer) {
        for (MessagePrinter<M> messagePrinter : this.printers) {
            messagePrinter.print(line, entryId, message, writer);
        }
    }

    public String toString() {
        return this.pattern;
    }

    private MessagePrinter<? super M>[] parse(String pattern) {
        ArrayList<MessagePrinter<M>> printers = new ArrayList<MessagePrinter<M>>();
        int end = -1;
        int start = pattern.indexOf(123, end + 1);
        while (start >= 0) {
            int pre = end + 1;
            end = pattern.indexOf(125, start + 1);
            if (end < 0) break;
            if (pre < (start = ParameterizedMessagePrinter.lastIndexOf(pattern, '{', start, end))) {
                printers.add(ParameterizedMessagePrinter.stringPrinter(pattern.substring(pre, start)));
            }
            printers.add(this.placeHolderPrinter(pattern.substring(start, end + 1)));
            start = pattern.indexOf(123, end + 1);
        }
        if (end + 1 < pattern.length()) {
            printers.add(ParameterizedMessagePrinter.stringPrinter(pattern.substring(end + 1)));
        }
        MessagePrinter[] arr = printers.toArray(new MessagePrinter[0]);
        return arr;
    }

    private static int lastIndexOf(String s, char ch, int start, int end) {
        assert (s.charAt(start) == ch);
        int index = start;
        int next = s.indexOf(ch, index + 1);
        while (next >= 0 && next < end) {
            index = next;
            next = s.indexOf(ch, index + 1);
        }
        return index;
    }

    private static MessagePrinter<Object> stringPrinter(String s) {
        return (line, entryId, message, writer) -> writer.write(s);
    }

    private MessagePrinter<M> placeHolderPrinter(String placeHolder) {
        return (line, entryId, message, writer) -> writer.write(String.valueOf(this.formatter.value(placeHolder, line, entryId, message)));
    }
}

