/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.format;

import java.util.Objects;
import org.tools4j.elara.flyweight.DataFrame;
import org.tools4j.elara.format.DataFrameFormatter;
import org.tools4j.elara.format.MessagePrinter;
import org.tools4j.elara.format.ValueFormatter;

public enum MessagePrinters {

    public static final String GENERAL_FORMAT = "{line}: {message}{nl}";
    public static final String PIPE_FORMAT = "{line}: in={input}|tp={type}}|sq={sequence}|tm={time}}|vs={version}|ix={index}|sz={payload-size}{nl}";
    public static final String SHORT_FORMAT = "{line}: in={input}, tp={type}, sq={sequence}, tm={time}, vs={version}, ix={index}, sz={payload-size}{nl}";
    public static final String LONG_FORMAT = "{line}: input={input}, type={type}, sequence={sequence}, time={time}, version={version}, index={index}, size={payload-size}{nl}";
    public static final String COMMAND_FORMAT = "{line}: {input}:{sequence} | type={type}, payload={payload} at {time}{version}{nl}";
    public static final String EVENT_FORMAT_CMD = "{line}: {input}:{sequence}.{index} | type={type}, payload={payload} at {time}{version}{nl}";
    public static final String EVENT_FORMAT_EVT = "{line}: {in-spc}.{seq-spc}.{index} | type={type}, payload={payload}{nl}";
    public static final MessagePrinter<Object> GENERAL = MessagePrinter.parameterized("{line}: {message}{nl}", ValueFormatter.DEFAULT);
    public static final MessagePrinter<DataFrame> PIPE = MessagePrinter.parameterized("{line}: in={input}|tp={type}}|sq={sequence}|tm={time}}|vs={version}|ix={index}|sz={payload-size}{nl}", DataFrameFormatter.DEFAULT);
    public static final MessagePrinter<DataFrame> SHORT = MessagePrinter.parameterized("{line}: in={input}, tp={type}, sq={sequence}, tm={time}, vs={version}, ix={index}, sz={payload-size}{nl}", DataFrameFormatter.DEFAULT);
    public static final MessagePrinter<DataFrame> LONG = MessagePrinter.parameterized("{line}: input={input}, type={type}, sequence={sequence}, time={time}, version={version}, index={index}, size={payload-size}{nl}", DataFrameFormatter.DEFAULT);
    public static final MessagePrinter<DataFrame> COMMAND = MessagePrinters.command(DataFrameFormatter.DEFAULT);
    public static final MessagePrinter<DataFrame> EVENT = MessagePrinters.event(DataFrameFormatter.DEFAULT);
    public static final MessagePrinter<DataFrame> FRAME = MessagePrinters.frame(DataFrameFormatter.DEFAULT);

    public static MessagePrinter<DataFrame> command(DataFrameFormatter formatter) {
        Objects.requireNonNull(formatter);
        return MessagePrinter.composite((line, entryId, frame) -> line == 0L ? 0 : 1, MessagePrinter.parameterized(COMMAND_FORMAT.replace("{version}", " (V {version})"), formatter), MessagePrinter.parameterized(COMMAND_FORMAT.replace("{version}", ""), formatter));
    }

    public static MessagePrinter<DataFrame> event(final DataFrameFormatter formatter) {
        Objects.requireNonNull(formatter);
        DataFrameFormatter inputSeqSpacer = new DataFrameFormatter(){

            @Override
            public Object value(String placeholder, long line, long entryId, DataFrame frame) {
                switch (placeholder) {
                    case "{in-spc}": {
                        return String.valueOf(formatter.input(line, entryId, frame)).replaceAll(".", ".");
                    }
                    case "{seq-spc}": {
                        return String.valueOf(formatter.sequence(line, entryId, frame)).replaceAll(".", ".");
                    }
                }
                return formatter.value(placeholder, line, entryId, frame);
            }
        };
        return MessagePrinter.composite((line, entryId, frame) -> {
            if (line == 0L) {
                return 0;
            }
            if (frame.header().index() == 0) {
                return 1;
            }
            return 2;
        }, MessagePrinter.parameterized(EVENT_FORMAT_CMD.replace("{version}", " (V {version})"), inputSeqSpacer), MessagePrinter.parameterized(EVENT_FORMAT_CMD, inputSeqSpacer), MessagePrinter.parameterized(EVENT_FORMAT_EVT, inputSeqSpacer));
    }

    public static MessagePrinter<DataFrame> frame(DataFrameFormatter formatter) {
        Objects.requireNonNull(formatter);
        return MessagePrinter.composite((line, entryId, frame) -> frame.header().index() < 0 ? 0 : 1, MessagePrinters.command(formatter), MessagePrinters.event(formatter));
    }
}

