/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.format;

import org.tools4j.elara.flyweight.DataFrame;
import org.tools4j.elara.flyweight.Header;
import org.tools4j.elara.format.ValueFormatter;

public interface DataFrameFormatter
extends ValueFormatter<DataFrame> {
    public static final DataFrameFormatter DEFAULT = new DataFrameFormatter(){};
    public static final String FRAME = "{frame}";
    public static final String HEADER = "{header}";
    public static final String INPUT = "{input}";
    public static final String TYPE = "{type}";
    public static final String SEQUENCE = "{sequence}";
    public static final String TIME = "{time}";
    public static final String VERSION = "{version}";
    public static final String INDEX = "{index}";
    public static final String PAYLOAD_SIZE = "{payload-size}";
    public static final String PAYLOAD = "{payload}";

    default public Object line(long line, long entryId, DataFrame frame) {
        return line;
    }

    default public Object entryId(long line, long entryId, DataFrame frame) {
        return entryId;
    }

    default public Object input(long line, long entryId, DataFrame frame) {
        return frame.header().input();
    }

    default public Object type(long line, long entryId, DataFrame frame) {
        Header header = frame.header();
        int type = header.type();
        if (header.index() >= 0) {
            if (type == -1) {
                return "C";
            }
            if (type == -2) {
                return "R";
            }
        }
        return type;
    }

    default public Object sequence(long line, long entryId, DataFrame frame) {
        return frame.header().sequence();
    }

    default public Object time(long line, long entryId, DataFrame frame) {
        return frame.header().time();
    }

    default public Object version(long line, long entryId, DataFrame frame) {
        return frame.header().version();
    }

    default public Object index(long line, long entryId, DataFrame frame) {
        return frame.header().index();
    }

    default public Object payloadSize(long line, long entryId, DataFrame frame) {
        return frame.header().payloadSize();
    }

    default public Object payload(long line, long entryId, DataFrame frame) {
        int size = frame.payload().capacity();
        return size == 0 ? "(empty)" : "(" + size + " bytes)";
    }

    @Override
    default public Object value(String placeholder, long line, long entryId, DataFrame frame) {
        switch (placeholder) {
            case "{nl}": {
                return System.lineSeparator();
            }
            case "{message}": 
            case "{frame}": {
                return frame;
            }
            case "{header}": {
                return frame.header();
            }
            case "{line}": {
                return this.line(line, entryId, frame);
            }
            case "{entry-id}": {
                return this.entryId(line, entryId, frame);
            }
            case "{input}": {
                return this.input(entryId, entryId, frame);
            }
            case "{type}": {
                return this.type(entryId, entryId, frame);
            }
            case "{sequence}": {
                return this.sequence(entryId, entryId, frame);
            }
            case "{time}": {
                return this.time(entryId, entryId, frame);
            }
            case "{version}": {
                return this.version(entryId, entryId, frame);
            }
            case "{index}": {
                return this.index(entryId, entryId, frame);
            }
            case "{payload-size}": {
                return this.payloadSize(entryId, entryId, frame);
            }
            case "{payload}": {
                return this.payload(entryId, entryId, frame);
            }
        }
        return placeholder;
    }
}

