/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.flyweight;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.tools4j.elara.flyweight.Frame;
import org.tools4j.elara.flyweight.Header;
import org.tools4j.elara.flyweight.Version;
import org.tools4j.elara.log.Flyweight;
import org.tools4j.elara.log.Writable;

public class FlyweightHeader
implements Flyweight<FlyweightHeader>,
Header,
Frame {
    private final MutableDirectBuffer header = new UnsafeBuffer(0L, 0);

    public FlyweightHeader init(int input, int type, long sequence, long time, short index, int payloadLSize, MutableDirectBuffer dst, int dstOffset) {
        FlyweightHeader.writeTo(input, sequence, index, type, time, payloadLSize, dst, dstOffset);
        return this.initSilent((DirectBuffer)dst, dstOffset);
    }

    public FlyweightHeader init(Header header, MutableDirectBuffer dst, int dstOffset) {
        return this.init(header.input(), header.type(), header.sequence(), header.time(), header.index(), header.payloadSize(), dst, dstOffset);
    }

    @Override
    public FlyweightHeader init(DirectBuffer src, int srcOffset) {
        Version.validate(src.getShort(srcOffset + 24));
        return this.initSilent(src, srcOffset);
    }

    private FlyweightHeader initSilent(DirectBuffer src, int srcOffset) {
        this.header.wrap(src, srcOffset, 32);
        return this;
    }

    public boolean valid() {
        return this.header.capacity() >= 32;
    }

    public FlyweightHeader reset() {
        this.header.wrap(0L, 0);
        return this;
    }

    @Override
    public Header header() {
        return this;
    }

    @Override
    public int input() {
        return this.header.getInt(0);
    }

    @Override
    public int type() {
        return this.header.getShort(4);
    }

    @Override
    public long sequence() {
        return this.header.getLong(8);
    }

    @Override
    public long time() {
        return this.header.getLong(16);
    }

    @Override
    public int version() {
        return 0xFFFF & this.header.getShort(24);
    }

    @Override
    public short index() {
        return this.header.getShort(26);
    }

    @Override
    public int payloadSize() {
        return this.header.getShort(28);
    }

    @Override
    public int write(Writable.BufferAcquirer bufferAcquirer) {
        MutableDirectBuffer buffer = bufferAcquirer.acquireBuffer(32);
        buffer.putBytes(0, (DirectBuffer)this.header, 0, 32);
        return 32;
    }

    @Override
    public int writeTo(MutableDirectBuffer dst, int dstOffset) {
        dst.putBytes(dstOffset + 0, (DirectBuffer)this.header, 0, 32);
        return 32;
    }

    public static int writeTo(int input, long sequence, short index, int type, long time, int payloadLSize, MutableDirectBuffer dst, int dstOffset) {
        dst.putInt(dstOffset + 0, input);
        dst.putInt(dstOffset + 4, type);
        dst.putLong(dstOffset + 8, sequence);
        dst.putLong(dstOffset + 16, time);
        dst.putShort(dstOffset + 24, (short)1);
        dst.putShort(dstOffset + 26, index);
        dst.putInt(dstOffset + 28, payloadLSize);
        return 32;
    }

    public String toString() {
        return this.valid() ? "FlyweightHeader{input=" + this.input() + ", type=" + this.type() + ", sequence=" + this.sequence() + ", time=" + this.time() + ", version=" + this.version() + ", index=" + this.index() + ", payload-size=" + this.payloadSize() + '}' : "FlyweightHeader";
    }
}

