/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.flyweight;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.event.EventHandler;
import org.tools4j.elara.event.EventRouter;
import org.tools4j.elara.event.RollbackMode;
import org.tools4j.elara.event.StateImpact;
import org.tools4j.elara.flyweight.FlyweightEvent;
import org.tools4j.elara.plugin.base.BaseEvents;

public class FlyweightEventRouter
implements EventRouter {
    private final EventHandler eventHandler;
    private final MutableDirectBuffer headerBuffer = new ExpandableDirectByteBuffer(32);
    private final FlyweightEvent flyweightEvent = new FlyweightEvent();
    private Command command;
    private RollbackMode rollbackMode;
    private short nextIndex = 0;

    public FlyweightEventRouter(EventHandler eventHandler) {
        this.eventHandler = Objects.requireNonNull(eventHandler);
    }

    public FlyweightEventRouter start(Command command) {
        this.command = Objects.requireNonNull(command);
        this.nextIndex = 0;
        this.rollbackMode = null;
        return this;
    }

    @Override
    public void routeEvent(int type, DirectBuffer event, int offset, int length) {
        FlyweightEventRouter.checkEventType(type);
        this.checkNotRolledBack();
        this.eventHandler.onEvent(this.flyweightEvent.init(this.headerBuffer, 0, this.command.id().input(), this.command.id().sequence(), this.nextIndex, type, this.command.time(), event, offset, length));
        this.flyweightEvent.reset();
        this.nextIndex = (short)(this.nextIndex + 1);
    }

    public boolean complete() {
        RollbackMode mode = this.rollbackMode;
        if (mode == null) {
            this.eventHandler.onEvent(BaseEvents.commit(this.flyweightEvent, this.headerBuffer, 0, this.command, this.nextIndex));
        } else if (this.nextIndex > 0 || mode != RollbackMode.REPLAY_COMMAND) {
            this.eventHandler.onEvent(BaseEvents.rollback(this.flyweightEvent, this.headerBuffer, 0, this.command, this.nextIndex));
        }
        this.flyweightEvent.reset();
        this.command = null;
        this.rollbackMode = null;
        this.nextIndex = 0;
        return mode != RollbackMode.REPLAY_COMMAND;
    }

    @Override
    public StateImpact rollbackAfterProcessing(RollbackMode mode) {
        this.rollbackMode = Objects.requireNonNull(mode);
        return this.nextIndex == 0 ? StateImpact.STATE_UNAFFECTED : StateImpact.STATE_CORRUPTION_POSSIBLE;
    }

    @Override
    public short nextEventIndex() {
        return this.nextIndex;
    }

    private static void checkEventType(int eventType) {
        if (eventType == -1 || eventType == -2) {
            throw new IllegalArgumentException("Illegal event type: " + eventType);
        }
    }

    private void checkNotRolledBack() {
        if (this.rollbackMode != null) {
            throw new IllegalStateException("It is illegal to route events after setting rollback mode");
        }
    }
}

