/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.flyweight;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.tools4j.elara.flyweight.DataFrame;
import org.tools4j.elara.flyweight.FlyweightHeader;
import org.tools4j.elara.flyweight.Header;
import org.tools4j.elara.log.Flyweight;
import org.tools4j.elara.log.Writable;

public class FlyweightDataFrame
implements Flyweight<FlyweightDataFrame>,
DataFrame {
    private final FlyweightHeader header = new FlyweightHeader();
    private final DirectBuffer payload = new UnsafeBuffer(0L, 0);

    public FlyweightDataFrame init(MutableDirectBuffer header, int headerOffset, int input, int type, long sequence, long time, short index, DirectBuffer payload, int payloadOffset, int payloadSize) {
        this.header.init(input, type, sequence, time, index, payloadSize, header, headerOffset);
        return this.initPayload(payload, payloadOffset, payloadSize);
    }

    public FlyweightDataFrame init(DirectBuffer header, int headerOffset, DirectBuffer payload, int payloadOffset, int payloadSize) {
        this.header.init(header, headerOffset);
        return this.initPayload(payload, payloadOffset, payloadSize);
    }

    @Override
    public FlyweightDataFrame init(DirectBuffer event, int offset) {
        return this.init(event, offset + 0, event, offset + 32, event.getInt(offset + 28));
    }

    private FlyweightDataFrame initPayload(DirectBuffer payload, int payloadOffset, int payloadSize) {
        if (payloadSize == 0) {
            this.payload.wrap(0L, 0);
        } else {
            this.payload.wrap(payload, payloadOffset, payloadSize);
        }
        return this;
    }

    public boolean valid() {
        return this.header.valid();
    }

    public FlyweightDataFrame reset() {
        this.header.reset();
        this.payload.wrap(0L, 0);
        return this;
    }

    @Override
    public Header header() {
        return this.header;
    }

    @Override
    public DirectBuffer payload() {
        return this.payload;
    }

    @Override
    public int write(Writable.BufferAcquirer bufferAcquirer) {
        int payloadSize = this.payload.capacity();
        MutableDirectBuffer dst = bufferAcquirer.acquireBuffer(32 + payloadSize);
        this.header.writeTo(dst, 0);
        this.payload.getBytes(0, dst, 32, payloadSize);
        return 32 + payloadSize;
    }

    @Override
    public int writeTo(MutableDirectBuffer dst, int offset) {
        int payloadSize = this.payload.capacity();
        this.header.writeTo(dst, offset);
        this.payload.getBytes(0, dst, offset + 32, payloadSize);
        return 32 + payloadSize;
    }

    public String toString() {
        return this.valid() ? "FlyweightDataFrame{input=" + this.header().input() + ", type=" + this.header().type() + ", sequence=" + this.header().sequence() + ", time=" + this.header().time() + ", version=" + this.header().version() + ", index=" + this.header().index() + ", payload-size=" + this.header().payloadSize() + '}' : "FlyweightDataFrame";
    }
}

