/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.input.SequenceGenerator;
import org.tools4j.elara.plugin.timer.TimerCommands;
import org.tools4j.elara.plugin.timer.TimerState;
import org.tools4j.elara.time.TimeSource;

public final class TimerTriggerInput
implements Input {
    private final TimerState timerState;
    private final TimeSource timeSource;
    private final SequenceGenerator adminSequenceGenerator;
    private final MutableDirectBuffer buffer = new ExpandableDirectByteBuffer(20);
    private final Input.Poller poller = new TimerTriggerPoller();

    public TimerTriggerInput(TimerState timerState, TimeSource timeSource, SequenceGenerator adminSequenceGenerator) {
        this.timerState = Objects.requireNonNull(timerState);
        this.timeSource = Objects.requireNonNull(timeSource);
        this.adminSequenceGenerator = Objects.requireNonNull(adminSequenceGenerator);
    }

    @Override
    public int id() {
        return 0;
    }

    @Override
    public Input.Poller poller() {
        return this.poller;
    }

    private class TimerTriggerPoller
    implements Input.Poller {
        private TimerTriggerPoller() {
        }

        @Override
        public int poll(Input.Handler handler) {
            int next = TimerTriggerInput.this.timerState.indexOfNextDeadline();
            if (next >= 0 && TimerTriggerInput.this.timerState.deadline(next) <= TimerTriggerInput.this.timeSource.currentTime()) {
                long seq = TimerTriggerInput.this.adminSequenceGenerator.nextSequence();
                int len = TimerCommands.triggerTimer(TimerTriggerInput.this.buffer, 0, TimerTriggerInput.this.timerState.id(next), TimerTriggerInput.this.timerState.type(next), TimerTriggerInput.this.timerState.timeout(next));
                handler.onMessage(seq, -10, (DirectBuffer)TimerTriggerInput.this.buffer, 0, len);
                return 1;
            }
            return 0;
        }
    }
}

