/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.command.CommandLoopback;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.plugin.timer.TimerCommands;
import org.tools4j.elara.plugin.timer.TimerEvents;
import org.tools4j.elara.plugin.timer.TimerState;

public class TimerEventApplier
implements EventApplier {
    private final TimerState.Mutable timerState;
    private final MutableDirectBuffer buffer = new ExpandableDirectByteBuffer(20);

    public TimerEventApplier(TimerState.Mutable timerState) {
        this.timerState = Objects.requireNonNull(timerState);
    }

    @Override
    public void onEvent(Event event, CommandLoopback loopback) {
        switch (event.type()) {
            case -11: {
                this.timerState.add(TimerEvents.timerId(event), TimerEvents.timerType(event), event.time(), TimerEvents.timerTimeout(event));
                break;
            }
            case -12: 
            case -10: {
                this.timerState.removeById(TimerEvents.timerId(event));
            }
        }
        this.tryEnqueueNextTriggerTimerCommand(event.time(), loopback);
    }

    private void tryEnqueueNextTriggerTimerCommand(long time, CommandLoopback loopback) {
        int next = this.timerState.indexOfNextDeadline();
        if (next >= 0 && this.timerState.deadline(next) <= time) {
            int len = TimerCommands.triggerTimer(this.buffer, 0, this.timerState.id(next), this.timerState.type(next), this.timerState.timeout(next));
            loopback.enqueueCommand(-10, (DirectBuffer)this.buffer, 0, len);
        }
    }
}

