/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import org.agrona.collections.IntArrayList;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.LongArrayList;
import org.tools4j.elara.plugin.timer.TimerState;

public class SimpleTimerState
implements TimerState.Mutable {
    public static final int DEFAULT_INITIAL_CAPACITY = 64;
    private final Long2LongHashMap idToIndex;
    private final LongArrayList ids;
    private final IntArrayList types;
    private final LongArrayList times;
    private final LongArrayList timeouts;

    public SimpleTimerState() {
        this(64);
    }

    public SimpleTimerState(int initialCapacity) {
        this.idToIndex = new Long2LongHashMap(2 * initialCapacity, 0.55f, -1L);
        this.ids = new LongArrayList(initialCapacity, 0L);
        this.types = new IntArrayList(initialCapacity, 0);
        this.times = new LongArrayList(initialCapacity, 0L);
        this.timeouts = new LongArrayList(initialCapacity, 0L);
    }

    @Override
    public int count() {
        return this.ids.size();
    }

    @Override
    public boolean hasTimer(long id) {
        return this.idToIndex.containsKey(id);
    }

    @Override
    public long id(int index) {
        return this.ids.getLong(index);
    }

    @Override
    public int type(int index) {
        return this.types.getInt(index);
    }

    @Override
    public long time(int index) {
        return this.times.getLong(index);
    }

    @Override
    public long timeout(int index) {
        return this.timeouts.getLong(index);
    }

    @Override
    public int indexById(long id) {
        return (int)this.idToIndex.get(id);
    }

    @Override
    public void remove(int index) {
        long id = this.ids.fastUnorderedRemove(index);
        this.idToIndex.remove(id);
        this.types.fastUnorderedRemove(index);
        this.times.fastUnorderedRemove(index);
        this.timeouts.fastUnorderedRemove(index);
        if (index < this.ids.size()) {
            this.idToIndex.put(this.ids.get(index).longValue(), (long)index);
        }
    }

    @Override
    public boolean add(long id, int type, long time, long timeout) {
        if (!this.hasTimer(id)) {
            this.idToIndex.put(id, (long)this.ids.size());
            this.ids.addLong(id);
            this.types.addInt(type);
            this.times.addLong(time);
            this.timeouts.addLong(timeout);
            return true;
        }
        return false;
    }
}

