/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import java.util.Objects;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.event.EventRouter;
import org.tools4j.elara.plugin.timer.TimerControl;
import org.tools4j.elara.plugin.timer.TimerEvents;
import org.tools4j.elara.plugin.timer.TimerState;

public class DefaultTimerControl
implements TimerControl {
    private final MutableDirectBuffer buffer;

    public DefaultTimerControl() {
        this((MutableDirectBuffer)new ExpandableDirectByteBuffer(20));
    }

    public DefaultTimerControl(MutableDirectBuffer buffer) {
        this.buffer = Objects.requireNonNull(buffer);
    }

    @Override
    public long startTimer(int type, long timeout, TimerState timerState, EventRouter eventRouter) {
        long id = DefaultTimerControl.nextTimerId(timerState, eventRouter);
        TimerEvents.timerStarted(this.buffer, 0, id, type, timeout, eventRouter);
        return id;
    }

    @Override
    public boolean stopTimer(long id, TimerState timerState, EventRouter eventRouter) {
        int index = timerState.indexById(id);
        if (index >= 0) {
            TimerEvents.timerStopped(this.buffer, 0, id, timerState.type(index), timerState.timeout(index), eventRouter);
            return true;
        }
        return false;
    }

    public static long nextTimerId(TimerState timerState, EventRouter eventRouter) {
        long maxId = DefaultTimerControl.maxTimerId(timerState);
        return Math.max(0L, maxId) + 1L + (long)eventRouter.nextEventIndex();
    }

    private static long maxTimerId(TimerState timerState) {
        long maxId = Long.MIN_VALUE;
        int count = timerState.count();
        for (int i = 0; i < count; ++i) {
            maxId = Long.max(maxId, timerState.id(i));
        }
        return maxId;
    }
}

