/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.loop;

import java.util.Objects;
import java.util.function.Function;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.nobark.loop.Step;

public final class SequencerStep
implements Step {
    private final BaseState baseState;
    private final Input.Poller[] inputPollers;
    private final Input.Handler[] handlers;
    private int roundRobinIndex = 0;

    public SequencerStep(BaseState baseState, Function<? super Input, ? extends Input.Handler> handlerFactory, Input ... inputs) {
        this.baseState = Objects.requireNonNull(baseState);
        this.inputPollers = this.initPollersFor(inputs);
        this.handlers = this.initHandlersFor(handlerFactory, inputs);
    }

    public boolean perform() {
        if (this.baseState.allEventsPolled()) {
            int count = this.inputPollers.length;
            for (int i = 0; i < count; ++i) {
                int index = this.getAndIncrementRoundRobinIndex(count);
                if (this.inputPollers[index].poll(this.handlers[index]) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private int getAndIncrementRoundRobinIndex(int count) {
        int index = this.roundRobinIndex++;
        if (this.roundRobinIndex >= count) {
            this.roundRobinIndex = 0;
        }
        return index;
    }

    private Input.Poller[] initPollersFor(Input ... inputs) {
        Input.Poller[] pollers = new Input.Poller[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            pollers[i] = inputs[i].poller();
        }
        return pollers;
    }

    private Input.Handler[] initHandlersFor(Function<? super Input, ? extends Input.Handler> handlerFactory, Input ... inputs) {
        Input.Handler[] handlers = new Input.Handler[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            handlers[i] = handlerFactory.apply(inputs[i]);
        }
        return handlers;
    }
}

