/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.log;

import java.util.Objects;
import org.agrona.collections.Long2LongHashMap;
import org.tools4j.elara.application.DuplicateHandler;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.log.MessageLog;

public class InputTrackingAppender
implements MessageLog.Appender<Command>,
MessageLog.Handler<Command> {
    private final MessageLog.Appender<? super Command> appender;
    private final Long2LongHashMap inputToSeqMap = new Long2LongHashMap(Long.MIN_VALUE);
    private final DuplicateHandler duplicateHandler;

    public InputTrackingAppender(MessageLog.Appender<? super Command> appender, DuplicateHandler duplicateHandler, MessageLog.Poller<? extends Command> poller) {
        this.appender = Objects.requireNonNull(appender);
        this.duplicateHandler = Objects.requireNonNull(duplicateHandler);
        while (poller.poll(this) > 0) {
        }
    }

    @Override
    public void append(Command command) {
        if (this.isNewCommand(command)) {
            this.appender.append(command);
        } else {
            this.duplicateHandler.dropCommandReceived(command);
        }
    }

    @Override
    public void onMessage(Command command) {
        this.isNewCommand(command);
    }

    private boolean isNewCommand(Command command) {
        int input = command.id().input();
        long currentSeq = command.id().sequence();
        long lastAppendedSeq = this.inputToSeqMap.get((long)input);
        if (lastAppendedSeq < currentSeq) {
            this.inputToSeqMap.put((long)input, currentSeq);
            return true;
        }
        return false;
    }
}

