/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.log;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.log.Flyweight;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.log.PeekableMessageLog;
import org.tools4j.elara.log.Writable;

public class InMemoryLog<M extends Writable>
implements PeekableMessageLog<M> {
    private final Flyweight<? extends M> flyweight;
    private final boolean remoteOnPoll;
    private Element root;
    private Element last;

    public InMemoryLog(Flyweight<? extends M> flyweight) {
        this(flyweight, true);
    }

    public InMemoryLog(Flyweight<? extends M> flyweight, boolean remoteOnPoll) {
        this.last = this.root = new Element();
        this.flyweight = Objects.requireNonNull(flyweight);
        this.remoteOnPoll = remoteOnPoll;
    }

    @Override
    public MessageLog.Appender<M> appender() {
        return message -> {
            MutableDirectBuffer buffer = this.last.buffer;
            this.last = this.last.append();
            message.writeTo(buffer, 0);
        };
    }

    @Override
    public PeekableMessageLog.PeekablePoller<M> poller() {
        return new PeekableMessageLog.PeekablePoller<M>(){
            Element current;
            {
                this.current = InMemoryLog.this.root;
            }

            @Override
            public int peekOrPoll(PeekableMessageLog.PeekPollHandler<? super M> handler) {
                if (this.current.next == null) {
                    return 0;
                }
                Writable flyMessage = (Writable)InMemoryLog.this.flyweight.init((DirectBuffer)this.current.buffer, 0);
                PeekableMessageLog.PeekPollHandler.Result result = handler.onMessage(flyMessage);
                if (result == PeekableMessageLog.PeekPollHandler.Result.POLL) {
                    this.current = this.current.next;
                    if (InMemoryLog.this.remoteOnPoll) {
                        ((InMemoryLog)InMemoryLog.this).root.next = null;
                        InMemoryLog.this.root = this.current;
                    }
                    return 1;
                }
                return 0;
            }

            @Override
            public int poll(MessageLog.Handler<? super M> handler) {
                if (this.current.next == null) {
                    return 0;
                }
                Writable flyMessage = (Writable)InMemoryLog.this.flyweight.init((DirectBuffer)this.current.buffer, 0);
                handler.onMessage(flyMessage);
                this.current = this.current.next;
                if (InMemoryLog.this.remoteOnPoll) {
                    ((InMemoryLog)InMemoryLog.this).root.next = null;
                    InMemoryLog.this.root = this.current;
                }
                return 1;
            }
        };
    }

    @Override
    public long size() {
        int size = 0;
        Element e = this.root;
        while (e.next != null) {
            ++size;
            e = e.next;
        }
        return size;
    }

    private static final class Element {
        final MutableDirectBuffer buffer = new ExpandableArrayBuffer();
        Element next;

        private Element() {
        }

        Element append() {
            this.next = new Element();
            return this.next;
        }
    }
}

