/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.tools4j.elara.application.Application;
import org.tools4j.elara.application.DuplicateHandler;
import org.tools4j.elara.application.ExceptionHandler;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.handler.InputHandlerFactory;
import org.tools4j.elara.init.Context;
import org.tools4j.elara.init.Singletons;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.log.InputTrackingAppender;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.log.PeekableMessageLog;
import org.tools4j.elara.loop.CommandPollerStep;
import org.tools4j.elara.loop.DutyCycle;
import org.tools4j.elara.loop.EventPollerStep;
import org.tools4j.elara.loop.SequencerStep;
import org.tools4j.elara.output.Output;
import org.tools4j.elara.plugin.Plugin;
import org.tools4j.elara.time.TimeSource;
import org.tools4j.nobark.run.ThreadLike;

final class DefaultContext<A extends Application>
implements Context<A> {
    private static final String DEFAULT_THREAD_NAME = "duty-cycle";
    private final A application;
    private final List<Input> inputs = new ArrayList<Input>();
    private final List<Plugin.Builder<? super A>> plugins = new ArrayList<Plugin.Builder<? super A>>();
    private Output output = event -> {};
    private PeekableMessageLog<Command> commandLog;
    private MessageLog<Event> eventLog;
    private TimeSource timeSource;
    private ExceptionHandler exceptionHandler = ExceptionHandler.DEFAULT;
    private DuplicateHandler duplicateHandler = DuplicateHandler.DEFAULT;
    private IdleStrategy idleStrategy = new BackoffIdleStrategy(100L, 10L, TimeUnit.MICROSECONDS.toNanos(1L), TimeUnit.MICROSECONDS.toNanos(100L));
    private ThreadFactory threadFactory;

    public DefaultContext(A application) {
        this.application = (Application)Objects.requireNonNull(application);
    }

    @Override
    public A application() {
        return this.application;
    }

    @Override
    public List<Input> inputs() {
        return this.inputs;
    }

    @Override
    public Context<A> input(Input input) {
        this.inputs.add(input);
        return this;
    }

    @Override
    public Context<A> input(int id, Input.Poller poller) {
        return this.input(Input.create(id, poller));
    }

    @Override
    public Output output() {
        return this.output;
    }

    @Override
    public Context<A> output(Output output) {
        this.output = Objects.requireNonNull(output);
        return this;
    }

    @Override
    public PeekableMessageLog<Command> commandLog() {
        return this.commandLog;
    }

    @Override
    public Context<A> commandLog(String file) {
        throw new IllegalStateException("not supported yet");
    }

    @Override
    public Context<A> commandLog(PeekableMessageLog<Command> commandLog) {
        this.commandLog = Objects.requireNonNull(commandLog);
        return this;
    }

    @Override
    public MessageLog<Event> eventLog() {
        return this.eventLog;
    }

    @Override
    public Context<A> eventLog(String file) {
        throw new IllegalStateException("not supported yet");
    }

    @Override
    public Context<A> eventLog(MessageLog<Event> eventLog) {
        this.eventLog = Objects.requireNonNull(eventLog);
        return this;
    }

    @Override
    public Context<A> plugin(Plugin<?> plugin) {
        return this.plugin(plugin.builder());
    }

    @Override
    public <P> Context<A> plugin(Plugin<P> plugin, Function<? super A, ? extends P> pluginStateProvider) {
        return this.plugin(plugin.builder(pluginStateProvider));
    }

    @Override
    public Context<A> plugin(Plugin.Builder<? super A> plugin) {
        this.plugins.add(plugin);
        return this;
    }

    @Override
    public List<Plugin.Builder<? super A>> plugins() {
        return this.plugins;
    }

    @Override
    public TimeSource timeSource() {
        return this.timeSource;
    }

    @Override
    public Context<A> timeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
        return this;
    }

    @Override
    public ExceptionHandler exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public Context<A> exceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
        return this;
    }

    @Override
    public DuplicateHandler duplicateHandler() {
        return this.duplicateHandler;
    }

    @Override
    public Context<A> duplicateHandler(DuplicateHandler duplicateHandler) {
        this.duplicateHandler = Objects.requireNonNull(duplicateHandler);
        return this;
    }

    @Override
    public IdleStrategy idleStrategy() {
        return this.idleStrategy;
    }

    @Override
    public Context<A> idleStrategy(IdleStrategy idleStrategy) {
        this.idleStrategy = Objects.requireNonNull(idleStrategy);
        return this;
    }

    @Override
    public ThreadFactory threadFactory() {
        return this.threadFactory;
    }

    @Override
    public Context<A> threadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    @Override
    public Context<A> threadFactory(String threadName) {
        return this.threadFactory(threadName == null ? null : r -> new Thread(null, r, threadName));
    }

    @Override
    public Context<A> validateAndPopulateDefaults() {
        if (this.application == null) {
            throw new IllegalStateException("Application must be set");
        }
        for (int i = 0; i < this.inputs.size(); ++i) {
            for (int j = i + 1; j < this.inputs.size(); ++j) {
                if (this.inputs.get(i).id() != this.inputs.get(j).id()) continue;
                throw new IllegalStateException("Duplicate input id: " + this.inputs.get(i).id());
            }
        }
        if (this.commandLog == null) {
            throw new IllegalStateException("Command log must be set");
        }
        if (this.eventLog == null) {
            throw new IllegalStateException("Event log must be set");
        }
        if (this.timeSource == null) {
            this.timeSource = System::currentTimeMillis;
        }
        if (this.threadFactory == null) {
            this.threadFactory(DEFAULT_THREAD_NAME);
        }
        return this;
    }

    public static DutyCycle dutyCycle(Context<?> context) {
        Singletons singletons = new Singletons(context);
        return new DutyCycle(DefaultContext.sequencerStep(context, singletons), DefaultContext.commandPollerStep(context, singletons), DefaultContext.eventApplierStep(context, singletons));
    }

    static InputHandlerFactory inputHandlerFactory(Context<?> context) {
        InputTrackingAppender commandAppender = new InputTrackingAppender(context.commandLog().appender(), context.duplicateHandler(), context.commandLog().poller());
        return new InputHandlerFactory(context.timeSource(), commandAppender);
    }

    static SequencerStep sequencerStep(Context<?> context, Singletons singletons) {
        return new SequencerStep(singletons.plugins.baseState, DefaultContext.inputHandlerFactory(context), singletons.plugins.inputs);
    }

    static CommandPollerStep commandPollerStep(Context<?> context, Singletons singletons) {
        return new CommandPollerStep(singletons.plugins.baseState, (PeekableMessageLog.PeekablePoller<? extends Command>)context.commandLog().poller(), singletons.commandHandler);
    }

    static EventPollerStep eventApplierStep(Context<?> context, Singletons singletons) {
        return new EventPollerStep(singletons.plugins.baseState, context.eventLog().poller(), singletons.eventHandler);
    }

    static org.tools4j.nobark.loop.IdleStrategy idleStrategy(Context<?> context) {
        final IdleStrategy idleStrategy = Objects.requireNonNull(context.idleStrategy());
        return new org.tools4j.nobark.loop.IdleStrategy(){

            public void idle() {
                idleStrategy.idle();
            }

            public void reset() {
                idleStrategy.reset();
            }

            public void idle(boolean workDone) {
                idleStrategy.idle(workDone ? 1 : 0);
            }

            public String toString() {
                return idleStrategy.toString();
            }
        };
    }

    static ThreadLike start(Context<?> context) {
        context.validateAndPopulateDefaults();
        return DefaultContext.dutyCycle(context).start(DefaultContext.idleStrategy(context), context.exceptionHandler(), context.threadFactory());
    }
}

