/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.handler;

import java.util.Objects;
import org.tools4j.elara.application.DuplicateHandler;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.application.ExceptionHandler;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.command.CommandLoopback;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.output.Output;
import org.tools4j.elara.plugin.base.BaseState;

public class EventHandler
implements MessageLog.Handler<Event> {
    private final BaseState.Mutable baseState;
    private final CommandLoopback commandLoopback;
    private final MessageLog.Appender<? super Event> eventLogAppender;
    private final Output output;
    private final EventApplier eventApplier;
    private final ExceptionHandler exceptionHandler;
    private final DuplicateHandler duplicateHandler;

    public EventHandler(BaseState.Mutable baseState, CommandLoopback commandLoopback, MessageLog.Appender<? super Event> eventLogAppender, Output output, EventApplier eventApplier, ExceptionHandler exceptionHandler, DuplicateHandler duplicateHandler) {
        this.baseState = Objects.requireNonNull(baseState);
        this.commandLoopback = Objects.requireNonNull(commandLoopback);
        this.eventLogAppender = Objects.requireNonNull(eventLogAppender);
        this.output = Objects.requireNonNull(output);
        this.eventApplier = Objects.requireNonNull(eventApplier);
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
        this.duplicateHandler = Objects.requireNonNull(duplicateHandler);
    }

    @Override
    public void onMessage(Event event) {
        Command.Id commandId = event.id().commandId();
        long lastAppliedForInput = this.baseState.lastCommandAllEventsApplied(commandId.input());
        if (lastAppliedForInput < commandId.sequence()) {
            if (this.baseState.allEventsPolled()) {
                this.eventLogAppender.append(event);
                this.publishEvent(event);
            }
            this.applyEvent(event);
            this.updateBaseState(event);
        } else {
            this.skipEvent(event);
        }
    }

    private void publishEvent(Event event) {
        try {
            this.output.publish(event);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleEventOutputException(event, t);
        }
    }

    private void applyEvent(Event event) {
        try {
            this.eventApplier.onEvent(event, this.commandLoopback);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleEventApplierException(event, t);
        }
    }

    private void updateBaseState(Event event) {
        this.baseState.lastAppliedEvent(event);
        if (event.type() == -1) {
            this.baseState.allEventsAppliedFor(event.id().commandId());
        }
    }

    private void skipEvent(Event event) {
        try {
            this.duplicateHandler.skipEventApplying(event);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleEventApplierException(event, t);
        }
    }
}

