/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.handler;

import java.util.Objects;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.application.DuplicateHandler;
import org.tools4j.elara.application.ExceptionHandler;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.flyweight.FlyweightEventRouter;
import org.tools4j.elara.log.PeekableMessageLog;
import org.tools4j.elara.plugin.base.BaseState;

public class CommandHandler
implements PeekableMessageLog.PeekPollHandler<Command> {
    private final BaseState baseState;
    private final FlyweightEventRouter eventRouter;
    private final CommandProcessor commandProcessor;
    private final ExceptionHandler exceptionHandler;
    private final DuplicateHandler duplicateHandler;

    public CommandHandler(BaseState baseState, FlyweightEventRouter eventRouter, CommandProcessor commandProcessor, ExceptionHandler exceptionHandler, DuplicateHandler duplicateHandler) {
        this.baseState = Objects.requireNonNull(baseState);
        this.eventRouter = Objects.requireNonNull(eventRouter);
        this.commandProcessor = Objects.requireNonNull(commandProcessor);
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
        this.duplicateHandler = Objects.requireNonNull(duplicateHandler);
    }

    @Override
    public PeekableMessageLog.PeekPollHandler.Result onMessage(Command command) {
        Command.Id cid = command.id();
        long lastAppliedForInput = this.baseState.lastCommandAllEventsApplied(cid.input());
        if (lastAppliedForInput < cid.sequence()) {
            if (this.baseState.processCommands()) {
                this.processCommand(command);
                return PeekableMessageLog.PeekPollHandler.Result.POLL;
            }
            return PeekableMessageLog.PeekPollHandler.Result.PEEK;
        }
        this.skipCommand(command);
        return PeekableMessageLog.PeekPollHandler.Result.POLL;
    }

    private void processCommand(Command command) {
        this.eventRouter.start(command);
        try {
            this.commandProcessor.onCommand(command, this.eventRouter);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleCommandProcessorException(command, t);
        }
        this.eventRouter.commit();
    }

    private void skipCommand(Command command) {
        try {
            this.duplicateHandler.skipCommandProcessing(command);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleCommandProcessorException(command, t);
        }
    }
}

