/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.flyweight;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.event.EventRouter;
import org.tools4j.elara.flyweight.FlyweightEvent;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.plugin.base.BaseEvents;

public class FlyweightEventRouter
implements EventRouter {
    private final MessageLog.Handler<? super Event> eventHandler;
    private final MutableDirectBuffer headerBuffer = new ExpandableDirectByteBuffer(32);
    private final FlyweightEvent flyweightEvent = new FlyweightEvent();
    private Command command;
    private short nextIndex = 0;

    public FlyweightEventRouter(MessageLog.Handler<? super Event> eventHandler) {
        this.eventHandler = Objects.requireNonNull(eventHandler);
    }

    public FlyweightEventRouter start(Command command) {
        this.command = Objects.requireNonNull(command);
        this.nextIndex = 0;
        return this;
    }

    @Override
    public void routeEvent(int type, DirectBuffer event, int offset, int length) {
        this.checkAllowedType(type);
        this.eventHandler.onMessage(this.flyweightEvent.init(this.headerBuffer, 0, this.command.id().input(), this.command.id().sequence(), this.nextIndex, type, this.command.time(), event, offset, length));
        this.flyweightEvent.reset();
        this.nextIndex = (short)(this.nextIndex + 1);
    }

    public FlyweightEventRouter commit() {
        this.eventHandler.onMessage(BaseEvents.commit(this.flyweightEvent, this.headerBuffer, 0, this.command, this.nextIndex));
        this.flyweightEvent.reset();
        this.command = null;
        this.nextIndex = 0;
        return this;
    }

    @Override
    public short nextEventIndex() {
        return this.nextIndex;
    }

    private void checkAllowedType(int eventType) {
        if (eventType == -1) {
            throw new IllegalArgumentException("Illegal event type: " + eventType);
        }
    }
}

