/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.flyweight;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.flyweight.Version;
import org.tools4j.elara.log.Flyweight;

public class FlyweightCommand
implements Flyweight<FlyweightCommand>,
Command,
Command.Id {
    private static final short INDEX_NEG = Short.MIN_VALUE;
    private final MutableDirectBuffer header = new UnsafeBuffer(0L, 0);
    private final DirectBuffer payload = new UnsafeBuffer(0L, 0);

    public FlyweightCommand init(MutableDirectBuffer header, int headerOffset, int input, long sequence, int type, long time, DirectBuffer payload, int payloadOffset, int payloadLSize) {
        FlyweightCommand.writeHeaderTo(header, headerOffset, input, sequence, type, time, payloadLSize);
        return this.initSlient((DirectBuffer)header, headerOffset, payload, payloadOffset, payloadLSize);
    }

    public FlyweightCommand init(DirectBuffer header, int headerOffset, DirectBuffer payload, int payloadOffset, int payloadSize) {
        Version.validate(header.getShort(headerOffset + 24));
        return this.initSlient(header, headerOffset, payload, payloadOffset, payloadSize);
    }

    private FlyweightCommand initSlient(DirectBuffer header, int headerOffset, DirectBuffer payload, int payloadOffset, int payloadSize) {
        this.header.wrap(header, headerOffset, 32);
        if (payloadSize == 0) {
            this.payload.wrap(0L, 0);
        } else {
            this.payload.wrap(payload, payloadOffset, payloadSize);
        }
        return this;
    }

    @Override
    public FlyweightCommand init(DirectBuffer command, int offset) {
        return this.init(command, offset + 0, command, offset + 32, command.getInt(offset + 28));
    }

    public FlyweightCommand reset() {
        this.header.wrap(0L, 0);
        this.payload.wrap(0L, 0);
        return this;
    }

    @Override
    public Command.Id id() {
        return this;
    }

    @Override
    public int input() {
        return this.header.getInt(0);
    }

    @Override
    public long sequence() {
        return this.header.getLong(8);
    }

    @Override
    public int type() {
        return this.header.getInt(4);
    }

    @Override
    public long time() {
        return this.header.getLong(16);
    }

    @Override
    public DirectBuffer payload() {
        return this.payload;
    }

    public static int writeHeaderTo(MutableDirectBuffer header, int headerOffset, int input, long sequence, int type, long time, int payloadLSize) {
        header.putInt(headerOffset + 0, input);
        header.putInt(headerOffset + 4, type);
        header.putLong(headerOffset + 8, sequence);
        header.putLong(headerOffset + 16, time);
        header.putShort(headerOffset + 24, (short)1);
        header.putShort(headerOffset + 26, (short)Short.MIN_VALUE);
        header.putInt(headerOffset + 28, payloadLSize);
        return 32;
    }

    @Override
    public int writeTo(MutableDirectBuffer buffer, int offset) {
        buffer.putBytes(offset + 0, (DirectBuffer)this.header, 0, 32);
        buffer.putBytes(offset + 32, this.payload, 0, this.payload.capacity());
        return 32 + this.payload.capacity();
    }

    public String toString() {
        if (this.header.capacity() < 32) {
            return "FlyweightCommand";
        }
        return "FlyweightCommand{input=" + this.header.getInt(0) + ", type=" + this.header.getInt(4) + ", sequence=" + this.header.getLong(8) + ", time=" + this.header.getLong(16) + ", version=" + this.header.getShort(24) + ", index=" + this.header.getShort(26) + ", payload-size=" + this.header.getInt(28) + '}';
    }
}

