/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.command;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.command.CommandLoopback;
import org.tools4j.elara.command.CommandType;
import org.tools4j.elara.flyweight.FlyweightCommand;
import org.tools4j.elara.input.SequenceGenerator;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.time.TimeSource;

public class DefaultCommandLoopback
implements CommandLoopback {
    private final MessageLog.Appender<? super Command> commandLogAppender;
    private final TimeSource timeSource;
    private final SequenceGenerator adminSequenceGenerator;
    private final MutableDirectBuffer buffer = new ExpandableDirectByteBuffer(52);
    private final FlyweightCommand flyweightCommand = new FlyweightCommand();

    public DefaultCommandLoopback(MessageLog.Appender<? super Command> commandLogAppender, TimeSource timeSource, SequenceGenerator adminSequenceGenerator) {
        this.commandLogAppender = Objects.requireNonNull(commandLogAppender);
        this.timeSource = Objects.requireNonNull(timeSource);
        this.adminSequenceGenerator = Objects.requireNonNull(adminSequenceGenerator);
    }

    @Override
    public void enqueueCommand(int type, DirectBuffer command, int offset, int length) {
        if (CommandType.isAdmin(type)) {
            throw new IllegalArgumentException("Invalid command type: " + type);
        }
        this.commandLogAppender.append(this.flyweightCommand.init(this.buffer, 0, 0, this.adminSequenceGenerator.nextSequence(), type, this.timeSource.currentTime(), command, offset, length));
        this.flyweightCommand.reset();
    }
}

