/*
 * Decompiled with CFR 0.152.
 */
package org.tonicsoft.timebomb;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import org.tonicsoft.timebomb.ITimeBomb;
import org.tonicsoft.timebomb.TestIgnorer;

public class TimeBombBase
implements ITimeBomb {
    private final TestIgnorer testIgnorer;

    public TimeBombBase(TestIgnorer testIgnorer) {
        this.testIgnorer = testIgnorer;
    }

    @Override
    public void blowUpAfter(LocalDate date) {
        this.blowUpIf(LocalDate.now().isAfter(date));
    }

    @Override
    public void blowUpAfter(LocalDateTime dateTime) {
        this.blowUpIf(LocalDateTime.now().isAfter(dateTime));
    }

    @Override
    public void blowUpAfter(OffsetDateTime offsetDateTime) {
        this.blowUpIf(OffsetDateTime.now().isAfter(offsetDateTime));
    }

    @Override
    public void blowUpAfter(ZonedDateTime zonedDateTime) {
        this.blowUpIf(ZonedDateTime.now().isAfter(zonedDateTime));
    }

    @Override
    public void blowUpAfter(long epochMillis) {
        this.blowUpIf(epochMillis < System.currentTimeMillis());
    }

    private static void blowUp() {
        throw new RuntimeException("TimeBomb has blown up.");
    }

    private void blowUpIf(boolean condition) {
        if (condition) {
            TimeBombBase.blowUp();
        }
    }

    @Override
    public void ignoreUntil(LocalDate date) {
        this.ignoreIf(LocalDate.now().isBefore(date), date.toString());
    }

    @Override
    public void ignoreUntil(LocalDateTime dateTime) {
        this.ignoreIf(LocalDateTime.now().isBefore(dateTime), dateTime.toString());
    }

    @Override
    public void ignoreUntil(OffsetDateTime offsetDateTime) {
        this.ignoreIf(OffsetDateTime.now().isBefore(offsetDateTime), offsetDateTime.toString());
    }

    @Override
    public void ignoreUntil(ZonedDateTime zonedDateTime) {
        this.ignoreIf(ZonedDateTime.now().isBefore(zonedDateTime), zonedDateTime.toString());
    }

    @Override
    public void ignoreUntil(long epochMillis) {
        this.ignoreIf(System.currentTimeMillis() < epochMillis, "" + epochMillis);
    }

    private void ignore(String ignoredUntil) {
        this.testIgnorer.ignoreCurrentlyRunningTest("Test ignored until " + ignoredUntil + ".");
    }

    private void ignoreIf(boolean condition, String ignoredUntil) {
        if (condition) {
            this.ignore(ignoredUntil);
        } else {
            TimeBombBase.blowUp();
        }
    }
}

