package org.ton.block

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import org.ton.bigint.*
import org.ton.cell.CellBuilder
import org.ton.cell.CellSlice
import org.ton.cell.invoke
import org.ton.tlb.TlbCodec
import org.ton.tlb.TlbConstructor
import org.ton.tlb.TlbObject
import org.ton.tlb.TlbPrettyPrinter
import kotlin.jvm.JvmName
import kotlin.jvm.JvmStatic

@SerialName("var_uint")
@Serializable
public data class VarUInteger(
    @get:JvmName("len")
    val len: Int,

    @Serializable(BigIntSerializer::class)
    @get:JvmName("value")
    val value: BigInt
) : TlbObject {
    @Deprecated("Use explicit constructor instead. In feature TLB classes will be auto-generated by TLB parser")
    public constructor(int: Int) : this(int.toBigInt())

    @Deprecated("Use explicit constructor instead. In feature TLB classes will be auto-generated by TLB parser")
    public constructor(long: Long) : this(long.toBigInt())

    @Deprecated("Use explicit constructor instead. In feature TLB classes will be auto-generated by TLB parser")
    public constructor(value: BigInt) : this(
        len = value.bitLength / Byte.SIZE_BITS + if (value.bitLength % Byte.SIZE_BITS == 0) 0 else 1,
        value = value
    )

    @Deprecated("Use VarUInteger.value instead")
    public fun toByte(): Byte = value.toByte()

    @Deprecated("Use VarUInteger.value instead")
    public fun toChar(): Char = value.toChar()

    @Deprecated("Use VarUInteger.value instead")
    public fun toDouble(): Double = throw UnsupportedOperationException()

    @Deprecated("Use VarUInteger.value instead")
    public fun toFloat(): Float = throw UnsupportedOperationException()

    @Deprecated("Use VarUInteger.value instead")
    public fun toInt(): Int = value.toInt()

    @Deprecated("Use VarUInteger.value instead")
    public fun toLong(): Long = value.toLong()

    @Deprecated("Use VarUInteger.value instead")
    public fun toShort(): Short = value.toShort()

    @Deprecated("Use VarUInteger.value instead")
    public operator fun plus(other: VarUInteger): VarUInteger {
        val result = value + other.value
        val maxLen = maxOf(len, other.len)
        val actualLen = result.bitLength
        val length = if (actualLen <= maxLen) maxLen else throw NumberFormatException("Integer overflow")
        return VarUInteger(length, result)
    }

    @Deprecated("Use VarUInteger.value instead")
    public operator fun minus(other: VarUInteger): VarUInteger {
        val result = value - other.value
        if (result < 0L) throw NumberFormatException("Integer underflow")
        val len = maxOf(len, other.len)
        return VarUInteger(len, result)
    }

    @Deprecated("Use VarUInteger.value instead")
    public operator fun times(other: VarUInteger): VarUInteger {
        val result = value * other.value
        val maxLen = maxOf(len, other.len)
        val actualLen = result.bitLength
        val len = if (actualLen <= maxLen) maxLen else throw NumberFormatException("Integer overflow")
        return VarUInteger(len, result)
    }

    @Deprecated("Use VarUInteger.value instead")
    public operator fun div(other: VarUInteger): VarUInteger {
        val result = value / other.value
        val maxLen = maxOf(len, other.len)
        val actualLen = result.bitLength
        val len = if (actualLen <= maxLen) maxLen else throw NumberFormatException("Integer overflow")
        return VarUInteger(len, result)
    }

    @Deprecated("Use VarUInteger.value instead")
    public operator fun rem(other: VarUInteger): VarUInteger {
        val result = value % other.value
        val maxLen = maxOf(len, other.len)
        val actualLen = result.bitLength
        val len = if (actualLen <= maxLen) maxLen else throw NumberFormatException("Integer overflow")
        return VarUInteger(len, result)
    }

    @Deprecated("Use VarUInteger.value instead")
    public operator fun inc(): VarUInteger {
        val result = value + 1.toBigInt()
        val actualLen = result.bitLength
        val length = if (actualLen < len) len else throw NumberFormatException("Integer overflow")
        return VarUInteger(length, result)
    }

    @Deprecated("Use VarUInteger.value instead")
    public operator fun dec(): VarUInteger {
        val result = value - 1.toBigInt()
        if (result < 0.toBigInt()) throw NumberFormatException("Integer overflow")
        return VarUInteger(len, result)
    }

    override fun print(printer: TlbPrettyPrinter): TlbPrettyPrinter {
        return printer.type("var_uint") {
            field("len", len)
            field("value", value)
        }
    }

    override fun toString(): String = value.toString()

    public companion object {
        @JvmStatic
        public fun tlbCodec(n: Int): TlbCodec<VarUInteger> = VarUIntegerTlbConstructor(n)
    }

    private class VarUIntegerTlbConstructor(
        val n: Int
    ) : TlbConstructor<VarUInteger>(
        schema = "var_uint\$_ {n:#} len:(#< n) value:(uint (len * 8)) = VarUInteger n;"
    ) {
        override fun storeTlb(
            cellBuilder: CellBuilder, value: VarUInteger
        ) = cellBuilder {
            storeUIntLes(value.len, n)
            storeUInt(value.value, value.len * 8)
        }

        override fun loadTlb(
            cellSlice: CellSlice
        ): VarUInteger = cellSlice {
            val len = loadUIntLes(n).toInt()
            val value = loadUInt(len * 8)
            VarUInteger(len, value)
        }
    }
}
