/*
 * Decompiled with CFR 0.152.
 */
package org.ton.adnl.peer;

import io.github.andreypfau.kotlinx.crypto.sha2.SHA256Kt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.ton.api.adnl.message.AdnlMessage;
import org.ton.api.adnl.message.AdnlMessagePart;
import org.ton.tl.ByteString;
import org.ton.tl.ByteStringKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/ton/adnl/peer/AdnlMessagePartEncoder;", "", "mtu", "", "maxSize", "(II)V", "getMaxSize", "()I", "getMtu", "encode", "", "Lorg/ton/api/adnl/message/AdnlMessagePart;", "message", "Lorg/ton/api/adnl/message/AdnlMessage;", "ton-kotlin-adnl"})
public final class AdnlMessagePartEncoder {
    private final int mtu;
    private final int maxSize;

    public AdnlMessagePartEncoder(int mtu, int maxSize) {
        this.mtu = mtu;
        this.maxSize = maxSize;
    }

    public /* synthetic */ AdnlMessagePartEncoder(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 8192;
        }
        this(n, n2);
    }

    public final int getMtu() {
        return this.mtu;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    @NotNull
    public final List<AdnlMessagePart> encode(@NotNull AdnlMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ArrayList<AdnlMessagePart> newMessages = new ArrayList<AdnlMessagePart>();
        byte[] b = AdnlMessage.Companion.encodeToByteArray((Object)message, true);
        if (!(b.length <= this.maxSize)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ByteString hash = ByteStringKt.asByteString((byte[])SHA256Kt.sha256((byte[])b));
        int size = b.length;
        for (int offset = 0; offset < size; offset += this.mtu) {
            byte[] byArray = b;
            int n = Math.min(offset + this.mtu, b.length);
            byte[] data = ArraysKt.copyOfRange((byte[])byArray, (int)offset, (int)n);
            AdnlMessagePart partMessage = new AdnlMessagePart(hash, size, offset, ByteStringKt.asByteString((byte[])data));
            newMessages.add(partMessage);
        }
        return newMessages;
    }
}

