/*
 * Decompiled with CFR 0.152.
 */
package org.ton.adnl.peer;

import io.github.andreypfau.kotlinx.crypto.sha2.SHA256Kt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.api.adnl.message.AdnlMessage;
import org.ton.api.adnl.message.AdnlMessagePart;
import org.ton.tl.ByteString;
import org.ton.tl.ByteStringKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/ton/adnl/peer/AdnlMessagePartDecoder;", "", "maxSize", "", "(I)V", "messageHash", "Lorg/ton/tl/ByteString;", "messageOffset", "messagePayload", "", "decode", "Lorg/ton/api/adnl/message/AdnlMessage;", "message", "Lorg/ton/api/adnl/message/AdnlMessagePart;", "Companion", "ton-kotlin-adnl"})
@SourceDebugExtension(value={"SMAP\nAdnlMessagePartDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdnlMessagePartDecoder.kt\norg/ton/adnl/peer/AdnlMessagePartDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class AdnlMessagePartDecoder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int maxSize;
    @NotNull
    private byte[] messagePayload;
    @NotNull
    private ByteString messageHash;
    private int messageOffset;
    @NotNull
    private static final ByteString ZERO_HASH = ByteStringKt.asByteString((byte[])new byte[32]);
    @NotNull
    private static final byte[] EMPTY_BYTES = new byte[0];

    public AdnlMessagePartDecoder(int maxSize) {
        this.maxSize = maxSize;
        this.messagePayload = EMPTY_BYTES;
        this.messageHash = ZERO_HASH;
    }

    public /* synthetic */ AdnlMessagePartDecoder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8192;
        }
        this(n);
    }

    @Nullable
    public final AdnlMessage decode(@NotNull AdnlMessagePart message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!(message.totalSize() <= this.maxSize)) {
            boolean $i$a$-check-AdnlMessagePartDecoder$decode$62 = false;
            String $i$a$-check-AdnlMessagePartDecoder$decode$62 = "too big message: size=" + message.totalSize();
            throw new IllegalStateException($i$a$-check-AdnlMessagePartDecoder$decode$62.toString());
        }
        if (!(message.data().size() + message.offset() <= message.totalSize())) {
            boolean $i$a$-check-AdnlMessagePartDecoder$decode$72 = false;
            String $i$a$-check-AdnlMessagePartDecoder$decode$72 = "bad part";
            throw new IllegalStateException($i$a$-check-AdnlMessagePartDecoder$decode$72.toString());
        }
        if (!Intrinsics.areEqual((Object)message.hash(), (Object)ZERO_HASH)) {
            boolean $i$a$-check-AdnlMessagePartDecoder$decode$82 = false;
            String $i$a$-check-AdnlMessagePartDecoder$decode$82 = "zero hash";
            throw new IllegalStateException($i$a$-check-AdnlMessagePartDecoder$decode$82.toString());
        }
        if (!(message.totalSize() == this.messagePayload.length)) {
            boolean $i$a$-check-AdnlMessagePartDecoder$decode$92 = false;
            String $i$a$-check-AdnlMessagePartDecoder$decode$92 = "invalid size";
            throw new IllegalStateException($i$a$-check-AdnlMessagePartDecoder$decode$92.toString());
        }
        if (!Intrinsics.areEqual((Object)message.hash(), (Object)this.messageHash)) {
            this.messageHash = message.offset() == 0 ? message.hash() : ZERO_HASH;
            this.messagePayload = new byte[message.totalSize()];
        }
        int currentMessageOffset = this.messageOffset;
        if (message.offset() == currentMessageOffset) {
            int totalSize;
            ByteString.copyInto$default((ByteString)message.data(), (byte[])this.messagePayload, (int)message.offset(), (int)0, (int)0, (int)12, null);
            this.messageOffset = totalSize = currentMessageOffset + message.data().size();
            if (totalSize == this.messagePayload.length) {
                byte[] actualMessageHash = SHA256Kt.sha256((byte[])this.messagePayload);
                if (!Intrinsics.areEqual((Object)ByteStringKt.asByteString((byte[])actualMessageHash), (Object)this.messageHash)) {
                    boolean bl = false;
                    String string = "hash mismatch, expected: " + this.messageHash + ", actual: " + actualMessageHash;
                    throw new IllegalStateException(string.toString());
                }
                return (AdnlMessage)AdnlMessage.Companion.decodeBoxed(this.messagePayload);
            }
        }
        return null;
    }

    public AdnlMessagePartDecoder() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/ton/adnl/peer/AdnlMessagePartDecoder$Companion;", "", "()V", "EMPTY_BYTES", "", "ZERO_HASH", "Lorg/ton/tl/ByteString;", "ton-kotlin-adnl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

