/*
 * Decompiled with CFR 0.152.
 */
package org.ton.adnl.network;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.adnl.network.IPAddress;
import org.ton.api.adnl.AdnlAddressUdp6;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/ton/adnl/network/IPv6Address;", "Lorg/ton/adnl/network/IPAddress;", "address", "", "port", "", "([BI)V", "getAddress", "()[B", "host", "", "getHost", "()Ljava/lang/String;", "getPort", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toAdnlAddress", "Lorg/ton/api/adnl/AdnlAddressUdp6;", "toString", "ton-kotlin-adnl"})
@SourceDebugExtension(value={"SMAP\nIPAddress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IPAddress.kt\norg/ton/adnl/network/IPv6Address\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class IPv6Address
implements IPAddress {
    @NotNull
    private final byte[] address;
    private final int port;

    public IPv6Address(@NotNull byte[] address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.address = address;
        this.port = port;
        int n = this.getPort();
        if (!(0 <= n ? n < 65536 : false)) {
            boolean $i$a$-require-IPv6Address$32 = false;
            String $i$a$-require-IPv6Address$32 = "Invalid port: " + this.getPort();
            throw new IllegalArgumentException($i$a$-require-IPv6Address$32.toString());
        }
        if (!(this.address.length == 16)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Invalid address: ");
            String string = Arrays.toString(this.address);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = stringBuilder.append(string).toString();
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final byte[] getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    @NotNull
    public String getHost() {
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public AdnlAddressUdp6 toAdnlAddress() {
        return new AdnlAddressUdp6(this.address, this.getPort());
    }

    @NotNull
    public String toString() {
        return this.getHost() + ':' + this.getPort();
    }

    @NotNull
    public final byte[] component1() {
        return this.address;
    }

    public final int component2() {
        return this.port;
    }

    @NotNull
    public final IPv6Address copy(@NotNull byte[] address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return new IPv6Address(address, port);
    }

    public static /* synthetic */ IPv6Address copy$default(IPv6Address iPv6Address, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            byArray = iPv6Address.address;
        }
        if ((n2 & 2) != 0) {
            n = iPv6Address.port;
        }
        return iPv6Address.copy(byArray, n);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.address);
        result = result * 31 + Integer.hashCode(this.port);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IPv6Address)) {
            return false;
        }
        IPv6Address iPv6Address = (IPv6Address)other;
        if (!Intrinsics.areEqual((Object)this.address, (Object)iPv6Address.address)) {
            return false;
        }
        return this.port == iPv6Address.port;
    }
}

