/*
 * Decompiled with CFR 0.152.
 */
package org.ton.adnl.network;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.adnl.UtilsKt;
import org.ton.adnl.network.IPAddress;
import org.ton.api.adnl.AdnlAddressUdp;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/ton/adnl/network/IPv4Address;", "Lorg/ton/adnl/network/IPAddress;", "host", "", "port", "", "(Ljava/lang/String;I)V", "address", "(II)V", "getAddress", "()I", "getHost", "()Ljava/lang/String;", "getPort", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toAdnlAddress", "Lorg/ton/api/adnl/AdnlAddressUdp;", "toString", "ton-kotlin-adnl"})
@SourceDebugExtension(value={"SMAP\nIPAddress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IPAddress.kt\norg/ton/adnl/network/IPv4Address\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class IPv4Address
implements IPAddress {
    private final int address;
    private final int port;

    public IPv4Address(int address, int port) {
        this.address = address;
        this.port = port;
        int n = this.getPort();
        if (!(0 <= n ? n < 65536 : false)) {
            boolean bl = false;
            String string = "Invalid port: " + this.getPort();
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public IPv4Address(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this(UtilsKt.ipv4(host), port);
    }

    @Override
    @NotNull
    public String getHost() {
        return UtilsKt.ipv4(this.address);
    }

    @NotNull
    public AdnlAddressUdp toAdnlAddress() {
        return new AdnlAddressUdp(this.address, this.getPort());
    }

    @NotNull
    public String toString() {
        return this.getHost() + ':' + this.getPort();
    }

    public final int component1() {
        return this.address;
    }

    public final int component2() {
        return this.port;
    }

    @NotNull
    public final IPv4Address copy(int address, int port) {
        return new IPv4Address(address, port);
    }

    public static /* synthetic */ IPv4Address copy$default(IPv4Address iPv4Address, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = iPv4Address.address;
        }
        if ((n3 & 2) != 0) {
            n2 = iPv4Address.port;
        }
        return iPv4Address.copy(n, n2);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.address);
        result = result * 31 + Integer.hashCode(this.port);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IPv4Address)) {
            return false;
        }
        IPv4Address iPv4Address = (IPv4Address)other;
        if (this.address != iPv4Address.address) {
            return false;
        }
        return this.port == iPv4Address.port;
    }
}

